<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class CompanyQuickpayPayments extends Model
{
    protected $table = 'company_quickpay_payments';


    protected $fillable = [
        'payment_id', 'order_id', 'accepted', 'created_user_id', 'type', 'currency', 'state', 'metadata', 'operations', 'subscription_id', 'balance', 'amount','company_id','vat'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function commissions()
    {
        return $this->hasMany('App\Commissions','package_id','company_id');
    }


    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


