<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Payouts extends Model
{
    protected $table = 'payouts';

    use SoftDeletes;

    protected $fillable = [
        'amount', 'created_user_id', 'updated_user_id','status', 'qp_status', 'order_id', 'operations','variables','payout_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }


}


