<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Payouts;


class PayoutError extends Mailable
{
    use Queueable, SerializesModels;

    public $payout;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Payouts $payout)
    {
        //

        $this->payout = $payout;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Iviggo - Payout Error')->view('emails.payout_error');
    }
}
