<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class GiftEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $verification_code;
    public $user_id;
    public $package_id;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->first_name = $user->first_name;
        $this->last_name = $user->last_name;
        $this->verification_code = $user->verification_code;
        $this->user_id = $user->user_id;
        $this->package_id = $user->package_id;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('iViggo | Gavemedlem tilmelding')->view('emails.giftuser');
    }
}
