<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;
use Spatie\Permission\Traits\HasRoles;
use Carbon\Carbon;


class CheckStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    use HasRoles;


    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if(isset($user->id)) {
            $details = User::find($user->id);
            if($details->marketing_status=='inactive') {
                Auth::logout();
                return redirect()->route('marketing.login')->with("error", "Your session has expired because your account is disabled.");
            }
        }

        // dates handles goes here
        return $next($request);
    }
}
