<?php

namespace App\Http\Controllers\Coach;

use App\CoachProfileInfo;
use App\Mail\CoachSignup;
use App\Mail\VideoUpload;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Storage;
use App\User;
use App\CoachIntro;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\IntroVideo;
use Illuminate\Support\Facades\File;

use Vimeo;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;


class IntroController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    protected function editvalidator(array $data)
    {
        return Validator::make($data, [
            'video_title' => 'required',
            'video_description' => 'nullable|string',
            'thumbnail' =>  'nullable|image|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',
        ],[
            'thumbnail.dimensions' => 'Image dimensions should not be less then 500px X 350px.',

        ]);
    }


    public function index(Request $request)
    {
        $this->user = Auth::user();


        //CoachProfileInfo::whereIn('created_user_id',)->pluck('invite_code');


        $records = CoachIntro::where('created_user_id', $this->user->id)->count();
        if ($records == 3) {
            return redirect()->back()->with('error', 'You already have 3 introductory videos!');
        }

        $data['vimeo_url'] = env('VIMEO_URL');
        //return $data;
        return view('coaches.intro', $data);
    }


    public function submit(Request $request)

    {


        $this->user = Auth::user();

        $validator = Validator::make($request->all(), [
            'video_title' => 'required',
            'video_description' => 'nullable|string',
            'uri' => 'required',
            'video_duration' => 'required|string',
            'thumbnail' => 'nullable|file|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',
        ],[
            'thumbnail.dimensions' => 'Image dimensions should not be less then 500px X 350px.',

        ]);

        if ($validator->passes()) {
            $this->default_condition = ["created_user_id" => $this->user->id, "updated_user_id" => $this->user->id];


            $rec = CoachIntro::where([
                'created_user_id' => $this->user->id
            ])->count();

            if ($rec == 3) {
                return redirect()->route('coach.dashboard')->with("error", "You already have 3 introductory videos.");
            }

            //return $fi
            if ($request->has('thumbnail')) {

                $image = $request->file('thumbnail');

                $image_name = time() . '.' . $image->getClientOriginalExtension();
                if (!File::exists(public_path('/uploads/thumbs/'))) {
                    File::makeDirectory(public_path('/uploads/thumbs/'));
                }

                $destinationPath = public_path('/uploads/images/');

                $resize_image = Image::load($image->getRealPath());

                /*$resize_image->fit(Manipulations::FIT_FILL,370,208)->background('ffffff')->save($destinationPath . '370_' . $image_name);

                $resize_image->fit(Manipulations::FIT_FILL,270,152)->background('ffffff')->save($destinationPath . '270_' . $image_name);*/


                $resize_image->width(470)->save($destinationPath . $image_name);

                $data['video_thumbnail'] = $image_name;
            }

            $array = explode('/', $request->input('uri'));
            $vimeoVidId = $array[2];
            $data['video_title'] = $request->input('video_title');
            $data['video_description'] = $request->input('video_description');
            $data['video_id'] = $vimeoVidId;
            $data['video_duration'] = round($request->input('video_duration'), 0);
            $data['status'] = 'inactive';
            $data['created_user_id'] = $this->user->id;
            $data['updated_user_id'] = $this->user->id;


            //return $data;
            $videoIntro = \App\CoachIntro::create($data);


            $managers = User::select(['id', 'first_name', 'last_name', 'email', 'status', 'created_at'])->role(['superadmin'])->where('status', 'active')->get();

            if ($managers && count($managers) > 0) {
                foreach ($managers as $manager) {
                    Mail::to($manager->email)->send(new IntroVideo($this->user));
                }
            }


            $response['status'] = 'success';
            $response["message"] = "Introductory Video Added.";
            $code = 200;

            return response()->json($response);
        }

        return response()->json(['error' => $validator->errors()->all()]);


        //return redirect('/coach/profile')->with('status', 'Profile updated!');


    }

    public function edit($id)
    {
        $this->user = Auth::user();
        $data["rec"] = CoachIntro::where(['id' => $id, 'created_user_id' => $this->user->id])->first();
        //return $data;
        if (!isset($data["rec"]->id)) {
            return redirect()->back()->with("error", "Introductory video not found");
        }

        return view('coaches.intro_edit', $data);
    }

    public function update(Request $request)
    {
        $this->user = Auth::user();

        $rec = CoachIntro::where('id', $request->input('id'))->get()->first();


        if ($rec->created_user_id == $this->user->id) {
            $this->editvalidator($request->all(), $request->input('id'))->validate();


            if ($request->has('thumbnail')) {

                // Get image file
                $image = $request->file('thumbnail');

                $image_name = time() . '.' . $image->getClientOriginalExtension();

                if (! File::exists(public_path('/uploads/thumbs/'))) {
                    File::makeDirectory(public_path('/uploads/thumbs/'));
                }

                if (! File::exists(public_path('/uploads/images/'))) {
                    File::makeDirectory(public_path('/uploads/images/'));
                }

                $destinationPath = public_path('/uploads/images/');

                $resize_image = Image::load($image->getRealPath());

                $resize_image->width(470)->save($destinationPath . $image_name);


                $rec->video_thumbnail = $image_name;
                $rec->vimeo_callback = 'done';

            }

            $rec->video_title = $request->input('video_title');
            $rec->video_description = $request->input('video_description');
            $rec->save();
            return redirect('/coach/profile')->with('status', 'Introductory video updated!');
        }
        //return $data;


        return redirect('/coach/profile')->with('error', 'invalid update!');
    }

    public function delete($id)
    {
        $this->user = Auth::user();

        $rec = CoachIntro::where('id', $id)->get()->first();

        if (!isset($rec->id)) {
            return redirect()->back()->with("error", "Introductory video not found");
        }
        if ($rec->created_user_id == $this->user->id) {

            $response = Vimeo::request('/videos', ['video_id' => $rec->video_id], 'Delete');

            CoachIntro::where('id', $id)->delete();
            return redirect('/coach/profile')->with('success', 'Introductory video deleted!');
        } else {


            return redirect()->back()->with("error", "Introductory video cannot be deleted");
        }
    }
}
