<?php

namespace App\Exports;

use App\CompanyQuickpayPayments;
use App\QuickpayPayments;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;


class PayoutsExport implements FromCollection
{
    /**
     * @return \Illuminate\Support\Collection
     */

    private $month;
    private $year;
    private $peter;

    public function __construct($month,$year, $peterFlag) {
        $this->month = $month;
        $this->year = $year;
        $this->peter = $peterFlag;
    }


    public function collection()
    {
        // Package Payments
        $payments = QuickpayPayments::with(['commissions','user'=>function ($q) {
            $q->withTrashed();
        }])->whereMonth('created_at', $this->month)->whereYear('created_at', $this->year)->where('type','Payment')->where('State','Approved')->orderBy('created_at', 'asc')->get();


        // Company Payments
        $companyPayments = CompanyQuickpayPayments::with(['commissions','user'=>function ($q) {
            $q->withTrashed();
        }])->whereMonth('created_at', $this->month)->whereYear('created_at', $this->year)->where('type','Payment')->where('State','Approved')->orderBy('created_at', 'asc')->get();

        //return $payments;
        $collection = new Collection();
    /*    if($this->peter == 'true') {
            $peter = 'Peter Payout';
        }else{
            $peter = 'Null';
        }*/
        $collection[] = ['Date','User Name','Email','Payment ID','Order ID','Payment Type','Package Amount','Vat','Vat Percentage','Total Amount','TEO Payout','Simon Payout','Remaining Total'];
        if($payments || $companyPayments) {

            $i = 1;
            foreach($payments as $item) {
                $results = [];
                $results['Date'] = Carbon::parse($item->created_at)->format('d-m-Y H:i:s');
                $results['User Name'] = $item->user->first_name.' '.$item->user->last_name;
                $results['Email'] = $item->user->email;
                $results['Payment ID'] = $item->payment_id;
                $results['Order ID'] = $item->order_id;
                $results['Payment Type'] = $item->type;
                if($item->type=='Refund') {
                    $results['Package Amount'] = -1 * number_format($item->amount, 2, '.', '');
                    $results['Vat'] = number_format((($item->balance/100)-$item->amount), 2, '.', '');
                    $results['Vat Percentage'] = ($item->vat+0).'%';
                    $results['Total Amount'] = -1 * number_format(($item->balance/100), 2, '.', '');
                    //$results['Commission Total'] = number_format($item->commissions->pluck('commission')->sum(), 2, '.', '');
                    $results['TEO'] = '0.00';
                    $results['Simon'] = '0.00';

                    /*$results['Peter'] = '0.00';*/
                    $remaining_total = $results['Package Amount'];
                    $results['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                } else {
                    $results['Package Amount'] = number_format($item->amount, 2, '.', '');
                    $results['Vat'] = number_format((($item->balance/100)-$item->amount), 2, '.', '');
                    $results['Vat Percentage'] = ($item->vat+0).'%';
                    $results['Total Amount'] = number_format(($item->balance/100), 2, '.', '');
                    // $results['Commission Total'] = number_format($item->commissions->pluck('commission')->sum(), 2, '.', '');
                    $results['TEO'] = number_format(($item->amount * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                    $results['Simon'] = number_format(($item->amount * config('iviggo.simon_payout')['percentage']) / 100, 2, '.', '');
               /*     if($this->peter == 'true') {
                        $results['Peter'] = number_format(($item->amount * config('iviggo.peter_payout')['percentage']) / 100, 2, '.', '');
                    }else{
                        $results['Peter'] = '0.00';
                    }*/
                    $remaining_total = $results['Package Amount']  - $results['TEO'] - $results['Simon'];
                    $results['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                }
                $collection[] = $results;

            }

            foreach($companyPayments as $item) {

                $results2 = [];
                $results2['Date'] = Carbon::parse($item->created_at)->format('d-m-Y H:i:s');
                $results2['User Name'] = $item->user->first_name.' '.$item->user->last_name;
                $results2['Email'] = $item->user->email;
                $results2['Payment ID'] = $item->payment_id;
                $results2['Order ID'] = $item->order_id;
                $results2['Payment Type'] = $item->type;
                $vatValue = ($item->amount * ($item->vat+0)/100);

                if($item->type=='Refund') {
                    $results2['Package Amount'] = -1 * number_format($item->amount, 2, '.', '');
                    $results2['Vat'] = number_format($vatValue, 2, '.', '');
                    $results2['Vat Percentage'] = ($item->vat+0).'%';
                    $results2['Total Amount'] = -1 * number_format(($item->balance/100), 2, '.', '');
                    $results2['TEO'] = '0.00';
                    $results2['Simon'] = '0.00';
                    /*$results2['Peter'] = '0.00';*/
                    $remaining_total = $results2['Package Amount'];
                    $results2['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                } else {
                    $results2['Package Amount'] = number_format($item->amount, 2, '.', '');
                    $results2['Vat'] = number_format($vatValue, 2, '.', '');
                    $results2['Vat Percentage'] = ($item->vat+0).'%';
                    $results2['Total Amount'] = number_format(($item->balance/100), 2, '.', '');
                    $results2['TEO'] = number_format(($item->amount * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                    $results2['Simon'] = number_format(($item->amount * config('iviggo.simon_payout')['percentage']) / 100, 2, '.', '');
                    if($this->peter == 'true') {
                        $results['Peter'] = number_format(($item->amount * config('iviggo.peter_payout')['percentage']) / 100, 2, '.', '');
                    }else{
                        $results['Peter'] = '0.00';
                    }                  $remaining_total = $results2['Package Amount']  - $results2['TEO'] - $results2['Simon'] ;
                    $results2['Remaining Total'] = number_format($remaining_total, 2, '.', '');
                }
                $collection[] = $results2;
            }
            return $collection;
        } else {
            return [];
        }

    }
}
