<?php

namespace App\Console\Commands;

use App\Commissions;
use App\Jobs\RenewNotification;
use App\Payouts;
use App\User;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Traits\HasRoles;
use App\VideoView;
use App\Video;

class viewsPayout extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use SoftDeletes;
    protected $signature = 'views:payout {test?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Payout for Video Views at end of each month';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //

        $isTest = $this->argument('test');

        $currentDate = Carbon::now()->subMonth();


        if($isTest==2) {
            $currentDate = Carbon::now()->subDay();
        }


        $results = Commissions::whereMonth('created_at', $currentDate->month)
            ->whereYear('created_at', $currentDate->year)->where('type','views')->count('id');

        if($results>0) {
            return false;
        }


        $coaches = User::role('coach')->where('status', 'active')->get();
        $data = [];

        $data['total_clicks'] = VideoView::whereMonth('created_at', $currentDate->month)
            ->whereYear('created_at', $currentDate->year)
            ->count('id');

        $data['25_pool'] = DB::table('speakers_pool')
            ->whereMonth('pool_date', $currentDate->month)
            ->whereYear('pool_date', $currentDate->year)
            ->sum('amount');

        foreach($coaches as $coach) {
            $monthlyvideos = Video::withTrashed()->where(['created_user_id' => $coach->id,'status' => 'approved'])->orderBy('created_at', 'asc')->whereDate('created_at','<=', $currentDate->endOfMonth()->toDateString())->pluck('id');
            $monthlyvideos  = $monthlyvideos->unique();


            $data['coaches'][$coach->id]['my_clicks'] = 0;
            $data['coaches'][$coach->id]['my_clicks'] = VideoView::whereIn('video_id', $monthlyvideos)
                ->whereMonth('created_at', $currentDate->month)
                ->whereYear('created_at', $currentDate->year)->count('id');
            if (empty($data['total_clicks']) && empty($data['coaches'][$coach->id]['my_clicks'])) {
                $data['coaches'][$coach->id]['pecentage'] = 0;
            } else {
                $data['coaches'][$coach->id]['pecentage'] = number_format(($data['coaches'][$coach->id]['my_clicks'] / $data['total_clicks']) * 100, 2, '.', '');
            }

            if(!empty($data['coaches'][$coach->id]['pecentage']) && !empty($data['25_pool'])) {
                $data['coaches'][$coach->id]['my_commision'] = ($data['coaches'][$coach->id]['pecentage'] * $data['25_pool'])/100;
            } else {
                $data['coaches'][$coach->id]['my_commision'] = 0;
            }
            $data['coaches'][$coach->id]['pecentage'] = number_format($data['coaches'][$coach->id]['pecentage'],2,'.','');
            $data['coaches'][$coach->id]['my_commision'] = number_format($data['coaches'][$coach->id]['my_commision'],2,'.','');
        }

        if(isset($data['coaches'])) {
            foreach ($data['coaches'] as $itemK=>$itemv) {
                if(!empty($itemv['my_commision']) && $itemv['my_commision']!='0.00') {
                    $commission = new Commissions();
                    $commission->price = $data['25_pool'];
                    $commission->commission = $itemv['my_commision'];
                    $commission->percentage = $itemv['pecentage'];
                    $commission->partner_id = $itemK;
                    $commission->created_user_id = $itemK;
                    $commission->created_at = $currentDate->toDateString();
                    $commission->updated_user_id = $itemK;
                    $commission->status = 'approved';
                    $commission->type = 'views';
                    $commission->save();
                }

            }
        }


    }
}
