<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class CoachIntro extends Model
{
    protected $table = 'coach_intro';

    protected $fillable = [
        'video_id', 'video_title', 'status','video_duration' , 'video_description', 'video_thumbnail', 'created_user_id', 'updated_user_id','vimeo_callback'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


