@extends('layouts.app')
@section('content')
    <!-- breadcrumb banner content area start -->
    <div class="lernen_banner large bg-bgcoach">
        <div class="container">
            <div class="row">
                <div class="lernen_banner_title">
                    <h1>Coach panelet</h1>
            {{--        <h4>You can search coaches by country or language <br><br>Our expert panel consists of Coaches, Psychologists, <br>
Therapists, Mental trainers, Mentors, Motivational Speakers <br>
           all who are passionate about helping you

</h4>--}}
                    <h4><br>Ekspertpanelet består af anerkendte coaches, psykologer, terapeuter,  <br>mentaltrænere, mentorer og motiverende foredragsholdere <br>
                        Alle der brænder for at hjælpe dig<br><br>Hvis du i videobiblioteket ikke finder hvad du søger så skriv til panelet
                    </h4>
                    <br>
                    <br>
                    <div class="button-section"><a href="/questions" class="color-two btn-custom">Spørg her</a></div>
                </div>
            </div>
        </div>
    </div>
    <!-- end breadcrumb banner content area start -->
    <div class="library-filter mb20">
        <div class="container">
            <form action="{{route('coaches.filter')}}" id="filter_form">
                {{ csrf_field() }}
            <div class="row ">

                <div class="col-md-4">
                    {{ Form::select('country', [null=>'Søg efter Land'] + $countries, isset($country) ? $country : null, ['class' => 'form-control filter','id'=>'country','data-placeholder'=>'Select']) }}


                </div>


                {{--<div class="col-sm-3">
                    {{ Form::select('state', $duration, isset($state) ? $state : null , ['class' => 'form-control filter']) }}
                </div>--}}
            </div>
            </form>
        </div>
    </div>
    <!-- projects area start -->
    <div id="projects">
        <div class="container mt-4">
            @include('common.flash_messages')
            <!-- .row -->
                @if(count($users)>0)
                    <div class="row">

                    @foreach($users as $user)
                <div class="col-lg-3 col-md-4 col-sm-6 col-12 course-single mb25">
                    <!-- 1 -->

                    <div class="themeioan_services">
                        <article>
                            <!-- single services -->
                            <div class="blog-photo" style="background-image: url({{ asset('uploads/images/'.$user->coachInfo->photo) }});" data-toggle="tooltip" data-placement="top" title="{{$user->first_name}} {{$user->last_name}}">
                                <a href="{{route('coach.profile',['id'=>$user->id])}}"></a>


                            </div>
                            <div class="blog-content">
                                <h5 class="title"  ><a href="{{route('coach.profile',['id'=>$user->id])}}">{{$user->first_name}} {{$user->last_name}}</a>
                                </h5>
                                <p class="line-clamp line-clamp-2" >
                                    {!! Str::limit($user->coachInfo->introduction, 90, ' ...') !!}
                                </p>
                                <a href="{{route('coach.profile',['id'=>$user->id])}}" class="button-light"><i class="fas fa-arrow-right"></i>
                                    Læs Mere</a>

                            </div>
                        </article><!-- end single services -->
                    </div>

                </div>
                    @endforeach


            </div>
                @else

                    No Coaches Found.
            @endif
            <!-- .row end -->
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    {{ $users->appends($_GET)->links() }}
                </div>
            </div>
        </div>
    </div>
    <!-- projects area end -->
@endsection
