<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionsRepliesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('questions_replies', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('coach_id')->unsigned();

            $table->integer('video_id')->nullable()->unsigned();
            $table->bigInteger('question_id')->unsigned();
            $table->enum('status',array('read','unread'))->default('unread');
            $table->timestamps();

            $table->foreign('coach_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('question_id')->references('id')->on('questions')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('video_id')->references('id')->on('videos')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('questions_replies');
    }
}
