<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class UserCompanies extends Model
{
    protected $table = 'coach_companies';

    protected $fillable = [
        'company_id', 'subscription_id','state' ,'company_hash', 'agreed_members','recurring', 'status','starts_at', 'ends_at', 'cancels_at', 'canceled_at','created_user_id' ,'updated_user_id', 'contract_amount'
    ];

    public function getStartsAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }


    public function getEndsAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }


    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function plan()
    {
        return $this->belongsTo('App\Createcompany','company_id');
    }

    public function quickpaySubscription() {
        return $this->hasMany('App\CompanyQuickpaySubscriptions','created_user_id','created_user_id');
    }


}


