<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Video;


class VideoDeleted extends Mailable
{
    use Queueable, SerializesModels;


    public $first_name;
    public $last_name;
    public $content;
    public $video_title;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Video $video,$content=null)
    {
        //

        $this->first_name = $video->user->first_name;
        $this->last_name = $video->user->last_name;
        $this->video_title = $video->video_title;
        $this->content = $content;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Video Deleted')->view('emails.video_deleted');
    }
}
