<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class GiftSuccess extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $receiver_fname;
    public $receiver_lname;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user, User $senderuser)
    {
        $this->first_name = $senderuser->first_name;
        $this->last_name = $senderuser->last_name;
        $this->receiver_fname = $user->first_name;
        $this->receiver_lname = $user->last_name;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Iviggo | Gift Success')->view('emails.giftsuccess');
    }
}
