<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;
use Spatie\Permission\Traits\HasRoles;
use Carbon\Carbon;


class CheckAccount
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    use HasRoles;


    public function handle($request, Closure $next)
    {
        $user = Auth::user();




        if ($user->status == 'disable')
        {
            Auth::logout();
            return redirect()->to('login')->with('error', 'Your session has expired because your account is deactivated.');
        }

        // dates handles goes here
        return $next($request);
    }
}
