<?php

namespace App\Http\Controllers\Marketing;


use App\CoachProfileInfo;
use App\Countries;
use App\Http\Controllers\Controller;
use App\Jobs\RenewNotification;
use App\Mail\PayoutProcessed;
use App\Mail\PayoutError;
use App\Payouts;
use App\Presentation;
use App\QuickpayPayments;
use App\User;
use App\UserPackage;
use Carbon\Carbon;
use App\SitePages;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use QuickPay\QuickPay;
use Vimeo;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentProcessed;

class PayoutController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        // $this->middleware('auth');
    }

    public function fail(Request $request)
    {


        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            //return $query;
            $data['link'] = '';
            if ($request->session()->has('qpay_link')) {
                $data['link'] = $request->session()->pull('qpay_link');
            }

            return view('pages.payout_fail',$data);

        }

        abort(404);
    }

    public function success(Request $request)
    {

        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            return view('pages.payout_success');



        }

        abort(404);

    }


    public function info(Request $request)
    {
        Log::info('CallBack');
        $incoming = $request->getContent();
        $incoming = json_decode($incoming, true);

        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'ivpay')) {

            $payload = [];
            $payload['payout_id'] = $incoming['id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['variables'] = json_encode($incoming['variables']);
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            $payload['operations'] = json_encode($incoming['operations']);
            $payload['state'] = $incoming['state'];

            if (!empty($payload['payout_id'])) {
                return $this->checkpayments($payload);
            }

        }

    }

    public function checkpayments($payload)
    {

        Log::info('+++++++++++++++++++++++++++++++++++');
        Log::info('++    Check Payments Function    ++');
        Log::info('+++++++++++++++++++++++++++++++++++');
        $client = new QuickPay(':' . env('QUICKPAY_PAYOUT'));

        $payOut = Payouts::where('order_id', $payload['order_id'])->with(['user'])->first();

        if (isset($payOut->id)) {

            Log::info('++    Found Payout    ++');

            $userID = $payOut->user->id;
            Log::info('Payments - 1st - QP payout check');
            //sleep(5);
            $paymentControl = $client->request->get('/payouts/' . $payload['payout_id'])->asArray();

            $operationalMessage = $paymentControl['operations'][0];
            if ($paymentControl['accepted'] == true && $operationalMessage['type'] == 'credit' && $operationalMessage['qp_status_code'] == "20000") {
                $payOut->status = 'approved';
                $payOut->payout_id = $payload['payout_id'];
                $payOut->variables = $payload['variables'];
                $payOut->operations = $payload['operations'];
                $payOut->qp_status = $operationalMessage['qp_status_msg'];
                $payOut->save();
                Mail::to($payOut->user->email)->send(new PayoutProcessed($payOut));
            } else {
                $payOut->status = 'rejected';
                $payOut->qp_status = $operationalMessage['qp_status_msg'];

                $payOut->save();
                Mail::to($payOut->user->email)->send(new PayoutError($payOut));
            }



        } else {
            Log::info('++  No Payoyt Found  ++');
        }

    }


}
