<?php

namespace App\Http\Controllers\Bo;

use App\CoachProfileInfo;
use App\QuestionReplies;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use DB;
use App\Video;
use App\CoachIntro;
use App\Category;


class CategoriesController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function index(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        //$data["user"] = User::with(['coachInfo'])->get();

        $data['categories'] = Category::with('Videos')->where('status', 'active')->orderBy('id', 'asc')->get();


        return view('bo.catagories', $data);
    }

    public function submit(Request $request)
    {

        $this->validate($request, [
            'type' => 'required|alpha'
        ]);

        $type = $request->input("type");

        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if ($type == 'add') {
            $this->validate($request, [
                'category' => 'required|regex:/^[a-zA-ZæøåÆØÅ0-9\s\-\_\,\#\/\.]+$/',
            ]);


            $category['title'] = $request->input("category");
            $category['status'] = "active";

            $data = Category::where('title', $category['title'])->first();

            if (isset($data->id)) {
                $response["message"] = "Category Already Exist.";
                $code = 422;
            } else {
                $this->default_condition = ['created_user_id' => $this->user->id, 'updated_user_id' => $this->user->id];
                Category::firstOrCreate(
                    ['title' => $request->input("category"), 'status' => 'active'],
                    $this->default_condition
                );

                $response["message"] = "Category Added.";
            }


        } elseif ($type == 'update') {

            $this->validate($request, [
                'category' => 'required|regex:/^[a-zA-ZæøåÆØÅ0-9\s\-\_\,\#\/\.]+$/',
                'id' => 'required|integer'
            ]);


            $data = Category::where('title', $request->input("category"))->where('id', '!=', $request->input('id'))->first();

            if (isset($data->id)) {
                $response["message"] = "Category already exist with same title.";
                $code = 422;
            } else {
                $category = Category::where('id', $request->input('id'))->get()->first();
                $category->title = $request->input("category");
                $category->save();
                $response["message"] = "Category Updated.";
            }



        } elseif ($type == 'delete') {

            $this->validate($request, [
                'id' => 'required|integer'
            ]);


            $category = Category::with('Videos')->where('id', $request->input('id'))->get()->first();
            if (isset($category->id) && $category->Videos->count() < 1) {
                $category->delete();
                $response["message"] = "Category Deleted.";
            } else {
                $response["message"] = "Category have videos.";
                $code = 422;
            }


        }

        $categories = Category::with('Videos')->where('status', 'active')->orderBy('id', 'asc')->get();
        $data['html'] = '';
        foreach ($categories as $category) {
            $data['html'] .= '<tr class="categoriesList"><td><input name="DynamicTextBox" type="text" value="' . $category->title . '" class="form-control"/></td>';
            $data['html'] .= '<td><button type="button" class="btn btn-success btn-cat-success rcat_u " data-id="' . $category->id . '">Save</button>&nbsp;&nbsp;';
            if ($category->videos->count() < 1) {
                $data['html'] .= '<button type="button" class="btn btn-danger remove rcat" data-id="' . $category->id . '">Delete</button>';
            }
            $data['html'] .= '</td></tr>';

        }
        $response["html"] = $data['html'];

        return response()->json($response, $code);

    }


}
