<?php

namespace App\Console\Commands;

use App\Jobs\RenewNotification;
use App\Payouts;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Traits\HasRoles;

class payoutCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use SoftDeletes;
    protected $signature = 'payout:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check Payouts in Waiting State';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $payouts = Payouts::where('status','waiting')->where('updated_at','<=',Carbon::now()->subMinutes('5')->toDateTimeString())->get();

        if(count($payouts) > 0) {
            foreach($payouts as $item) {
                $item->status = 'rejected';
                $item->save();
                $item->delete();

            }
        }

    }
}
