<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Commissions extends Model
{
    protected $table = 'commissions';

    protected $fillable = [
        'price', 'commission', 'percentage', 'package_id', 'user_package_id','partner_id','created_user_id','updated_user_id','status','type'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function partner()
    {
        return $this->belongsTo('App\User','partner_id');
    }

    public function plan()
    {
        return $this->belongsTo('App\Package','package_id');
    }

    public function user_package()
    {
        return $this->belongsTo('App\UserPackage','user_package_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


