<?php

    $collectionOfRoles = ['coach','superadmin'];
    $adminRoles = ['superadmin'];
    $coachOnly = ['coach'];
    $mixedUsers = ['coach','user'];
    $allroles = ['coach','user', 'superadmin'];


?>
<header id="header" class="sticky transparent-header ">
    <div class="topheader top_header_light ">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-4 content-center-mobile mb-1">
                    <div class="address-icon"><a href="tel:+45 42217569"><i class="fas fa-phone"></i>+45 42217569</a></div>
                    <div class="address-icon"><a href="mailto:support@iviggo.com"><i class="fas fa-envelope"></i>support@iviggo.com</a></div>
                </div>
                <?php if(Auth::check()): ?>

                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                            <?php if(auth()->check() && auth()->user()->hasRole($adminRoles)): ?>
                            <a href="<?php echo e(route('company.get')); ?>" >Registrer en Virksomhed</a>
                            <?php endif; ?>
                       
                            
                           
                            <?php if(auth()->check() && auth()->user()->hasAnyRole($collectionOfRoles)): ?>

                            <a href="<?php echo e(route('video.upload')); ?>"><i class="fas fa-plus-circle"></i>Upload Video</a>

                            <a href="<?php echo e(route('coach.dashboard')); ?>"><i class="fas fa-user-cog"></i>Min Profil</a>
                            <?php endif; ?>
                            <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                            <a href="<?php echo e(route('users.edit')); ?>"><i class="fas fa-user-cog"></i>Min Profil</a>
                            <?php endif; ?>
                            <a href="javascript:void(0)" id="logout">
                                <i class="fas fa-user-circle "></i>Log ud</a></div>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>


                    </div>


                <?php else: ?>
                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                           
                            <a href="<?php echo e(route('join')); ?>"><i class="fas fa-plus-circle"></i><?php echo e(__('Tilmeld nu')); ?></a><a
                                href="<?php echo e(route('login')); ?>"><i
                                    class="fas fa-user-circle "></i><?php echo e(__('Log på')); ?></a></div>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- #navigation start -->
    <nav class="navbar navbar-default navbar-expand-md navbar-light" id="navigation" data-offset-top="1">
        <!-- .container -->
        <div class="container">
            <!-- Logo and Menu -->
            <div class="navbar-header">
                <div class="navbar-brand"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('images/logo.svg')); ?>"
                                                                        alt="Logo"/></a></div>
                <!-- site logo -->
            </div>
            <!-- Menu Toogle -->
            <div class="burger-icon">
                <div class="bar1"></div>
                <div class="bar2"></div>
                <div class="bar3"></div>

            </div>
            
            <div class="collapse navbar-collapse " id="navbarCollapse">
                <ul class="nav navbar-nav ml-auto">
                    <!-- Menu Link -->
                    <?php if(Auth::check()): ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                        <li>
                        <a href="<?php echo e(route('user.payments')); ?>" class="<?php echo e((Route::currentRouteName()== 'user.payments') ? 'active' : ''); ?>">Mit Medlemskab</a>

                        </li>
                       
                        <?php endif; ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('coach')): ?>

                        <li class="subnav"><a href="#" >Mit admin</a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('bo.videos')); ?>" class="nav-link ">Godkend videoer </a></li>
                                <li><a href="<?php echo e(route('bo.intros')); ?>" class="nav-link ">Godkend introduktionsvideoer</a></li>
                                <?php if(auth()->check() && auth()->user()->hasRole('coach')): ?>
                                <li><a href="<?php echo e(route('bo.coaches')); ?>" class="nav-link ">Coach ansøgninger</a></li>
                                <?php endif; ?>
                            </ul>
                        </li>

                        <?php endif; ?>

                        <?php if(auth()->check() && auth()->user()->hasRole('superadmin')): ?>
                        <li class="subnav">
                            <a href="#" class="<?php echo e((strpos(Route::currentRouteName(), 'bo') === false) ? '' : 'active'); ?>">Admin</a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('bo.videos')); ?>" class="nav-link ">Godkend videoer (<?php echo e(getPendingVideosCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('bo.intros')); ?>" class="nav-link ">Godkend Introvideoer (<?php echo e(getPendingIntrosCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('bo.coaches')); ?>" class="nav-link ">Coach ansøgninger (<?php echo e(getPendingCoachesCount()); ?>)</a></li>
                                <li><a href="<?php echo e(route('manage.members')); ?>" class="nav-link ">Administrer medlemmer</a></li>
                                <li><a href="<?php echo e(route('bo.pages')); ?>" class="nav-link ">Administrer sider</a></li>
                                <li><a href="<?php echo e(route('bo.staff')); ?>" class="nav-link ">Administrer personale</a></li>
                                <li><a href="<?php echo e(route('bo.categories')); ?>" class="nav-link ">Administrer kategorier</a></li>
                                <li><a href="<?php echo e(route('bo.packages')); ?>" class="nav-link ">Administrer pakker</a></li>
                                <li><a href="<?php echo e(route('bo.questions')); ?>" class="nav-link ">Administrer spørgsmål</a></li>
                                <li><a href="<?php echo e(route('bo.payouts')); ?>" class="nav-link ">iviggo interne udbetalinger</a></li>
                       

                            </ul>
                        </li>
                        <?php endif; ?>


                    <?php endif; ?>
              
                    <li class="subnav">
                            <a href="#"><?php echo e(__('Hvad er iviggo')); ?></a>
                            <ul class="sub-menu">
                            <li><a href="<?php echo e(asset('documents/Iviggo_presentation-dan.pdf')); ?>" target="blank">iviggo til alle</a></li>
                                <li><a href="<?php echo e(asset('documents/company-package-dan.pdf')); ?>" target="blank">Firma aftale</a></li>
                            </ul>
                        </li>
                    <li>
                        <a href="<?php echo e(route('videos')); ?>" class="<?php echo e((Route::currentRouteName()=='videos') ? 'active' : ''); ?>"><?php echo e(__('Videobibliotek')); ?></a>

                    </li>

                    <li>
                        <a href="<?php echo e(route('coaches')); ?>" class="<?php echo e((Route::currentRouteName()=='coaches') ? 'active' : ''); ?>"><?php echo e(__('Coach panelet')); ?></a>

                    </li>
                

                    <?php if(auth()->check() && auth()->user()->hasRole('companyuser')): ?>
                    <li>
                        <a href="<?php echo e(route('users.employee')); ?>"><i class="fas fa-user-cog"></i>Min profil</a>
                    </li>
                    <?php endif; ?>
                    <?php if(Auth::check()): ?>

                        <?php if(auth()->check() && auth()->user()->hasAnyRole($collectionOfRoles)): ?>
                        <li>
                            <a href="<?php echo e(route('q.questions')); ?>" class="<?php echo e((Route::currentRouteName()=='q.questions') ? 'active' : ''); ?>">Video spørgsmålsboks</a>

                        </li>
                      

                        <?php endif; ?>
                        <?php if(auth()->check() && auth()->user()->hasRole('user')): ?>
                        <li>
                            <a href="<?php echo e(route('questions')); ?>" class="<?php echo e((Route::currentRouteName()=='questions') ? 'active' : ''); ?>">Video spørgsmålsboks</a>

                        </li>
                        <?php endif; ?>



                    <?php endif; ?>


                </ul>

            </div>
            <!-- Menu Toogle end -->
        </div>
        <!-- .container end -->
    </nav>
    <!-- #navigation end -->
</header>
<?php /**PATH /home/ivigoo/html/development/resources/views/partials/app/header.blade.php ENDPATH**/ ?>