<?php $__env->startSection('content'); ?>

    <div class="lernen_banner large bg-bgcoach">


        <div class="container">
            <div class="row">
                     <div class="col-md-12 mb-3">
                                    <h3 class="lernen_banner_title"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h3>
                                     <div class="bar"></div>
                                      <?php if(!empty($user->coachInfo->website)): ?>
                                <?php
                                    $url = $user->coachInfo->website;
                                    if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {

                                            // If not exist then add http
                                            $url = "http://" . $url;
                                        }

                                ?>
                                <h6>Hjemmeside: <a href="<?php echo e(url($url)); ?>"
                                               target="_blank"><?php echo e($user->coachInfo->website); ?></a>
                                </h6>
                            <?php endif; ?>
                                    <p><?php echo e($user->coachInfo->slogan); ?></p>
                     </div>



                     <div class="col-md-12 "><a class="color-two btn-custom" href="<?php echo e(route('coach.profile.edit')); ?>">Rediger Min Konto</a>
                     </div>

            </div>
        </div>
    </div>
    <!-- end breadcrumb banner content area start -->

    <!-- services area start -->
    <div id="profile">
        <!-- .container -->
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-6 col-sm-6">
                    <div class="dreidbgleft pr-img" style="background-image: url(<?php echo e(asset('uploads/images/'.$user->coachInfo->photo)); ?>);" data-toggle="tooltip" data-placement="top" title="<?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?>">

                    </div>
                </div>
                <div class="col-lg-7 col-md-6 col-sm-6">
                    <?php echo $__env->make('common.flash_messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <h5>Om mig</h5>
                            <p><?php echo e($user->coachInfo->introduction); ?></p>

                            <h5>Mit ekspertiseområde</h5>
                            <p><?php echo e($user->coachInfo->expertise); ?></p>

                            <div class="row black-text">
                                <!-- #counter -->
                                <div class="col-6 col-sm-6 col-md-4 col-lg-3">
                                    <div class="info">
                                        <!-- 1 -->
                                        <div class="themeioan_counter text-center">
                                            <!-- single counter item -->

                                            <h4><?php echo e($user->subscribers->count()); ?></h4>
                                            <p>Abonnenter</p>
                                        </div><!-- end single counter item -->
                                    </div>
                                </div>
                                <div class="col-6 col-sm-6 col-md-4 col-lg-3">
                                    <!-- .row -->
                                    <div class="info">
                                        <!-- 2 -->
                                        <div class="themeioan_counter text-center">
                                            <!-- single counter item -->

                                            <h4><?php echo e(count($user->video)); ?></h4>
                                            <p>Videoer i alt</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- .row end -->
                                <!-- #counter area end -->
                            </div>

                </div>
            </div>

            <div class="row">
                <div class="container mt-4">
                    <div class="row">
                        <div class="col-md-6">
                            <h5>Intro videoer</h5>
                        </div>

                        <div class="col-md-6">
                            <?php if($user->CoachIntro->count()<3): ?>
                                <a class="uploadguide color-two btn-custom" href="<?php echo e(route('coach.intro')); ?>">Upload intro video</a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <br>
                    <br>
                    <div class="row">
                        <div class="col-md-6">
                            <h5></h5>
                        </div>
                        <div class="col-md-6">

                                <a class="uploadguide color-two btn-custom" href="<?php echo e(route('coaches.pool')); ?>">Optjening Fra video pool</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="container mt-4 mb-3">
                <?php if(count($user->CoachIntro)>0): ?>
                        <div class="row">
                <?php $__currentLoopData = $user->CoachIntro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                        <div class="iconsets">

                            <button data-toggle="tooltip" data-placement="right" title="Edit Video" class="statusactive edit_intro" data-id="<?php echo e($rec->id); ?>"><i class=" fas fa-pencil-alt " aria-hidden="true"></i></button>
                            <button data-toggle="tooltip" data-placement="right" title="Delete Video" class="statusdeactive del_intro" aria-hidden="true" data-id="<?php echo e($rec->id); ?>"><i class="fa fa-trash " ></i>
                            </button>

                        </div>
                            <a data-id='<?php echo e($rec->video_id); ?>' href="#" class="color-gray-darker td-hover-none vimeo_play"  >
                            <div class="ba-0 ds-1 like-content">

                                <div style="background-image: url(<?php echo e(asset('uploads/images/'.$rec->video_thumbnail)); ?>);" class="card-img-top"></div>
                                <div class="card-body">

                                    <h4 class="card-title color-gray-darker" ><?php echo Str::limit($rec->video_title, 35, ' ...'); ?>

                                    </h4>
                                    <p class="card-text color-gray-darker" ><?php echo Str::limit($rec->video_description, 120, ' ...'); ?></p>
                                    <div class="course-viewer">
                                        <ul>

                                            <li>
                                                  <?php echo e(gmdate("H:i:s", $rec->video_duration)); ?>

                                            </li>
                                        </ul>
                                    </div>
                                    <div class="statusv-<?php echo e(($rec->status=='active' ? 'approved':'pending')); ?>">
                                        <?php echo e(($rec->status=='active' ? 'Approved':'Waiting for approval')); ?>

                                    </div>
                                </div>
                            </div>

                        </a>

                    </div>



                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                <?php else: ?>

                You don't have an introductory video yet.
                <?php endif; ?>
                </div>

            </div>

            <div class="row">
                <div class="container mt-4">
                    <h5>Videoer fra <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h5>
                    <?php if(count($user->video)>0): ?>
                    <div class="row">


                            <?php $__currentLoopData = $user->video; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    <?php if(Auth::check()): ?>
                                        <div class="iconsets">

                                            <button data-toggle="tooltip" data-placement="right" title="Edit Video" class="statusactive edit_vid" aria-hidden="true"
                                                    data-id="<?php echo e($video->id); ?>">
                                                <i class="fa fa-pencil-alt "></i></button>

                                            <button data-toggle="tooltip" data-placement="right" title="Delete Video" class="vd_act statusdeactive" data-id="<?php echo e($video->id); ?>" data-reason="no"
                                                    data-type="remove"><i
                                                    class="fa fa-trash " aria-hidden="true"></i></button>


                                        </div>

                                    <?php endif; ?>
                                    <?php if($video->status=='approved'): ?>
                                            <a href="<?php echo e(route('video.play',['id'=>$video->id])); ?>" class="color-gray-darker td-hover-none" target="_blank">
                                        <?php else: ?>
                                            <a data-id='<?php echo e($video->video_id); ?>' href="#"
                                               class="color-gray-darker td-hover-none vimeo_play">
                                        <?php endif; ?>

                                        <div class="ba-0 ds-1 like-content">
                                        <div class="course-viewer">
                                                    <ul>

                                                        <li>
                                                             <?php echo e(gmdate("H:i:s", $video->video_duration)); ?>

                                                        </li>
                                                    </ul>
                                                </div>


                                            <div style="background-image: url(<?php echo e(asset('uploads/images/'.$video->video_thumbnail)); ?>);" class="card-img-top"></div>
                                            <div class="card-body">
                                                <?php
                                                    $fullName = $video->user->first_name.' '.$video->user->last_name;
                                                ?>
                                                <span class="coach-name " ><?php echo Str::limit($fullName, 50, ' ...'); ?>

                                                        </span>
                                                <h4 class="card-title color-gray-darker"  ><?php echo Str::limit($video->video_title, 20, ' ...'); ?>

                                                </h4>
                                                <p class="card-text color-gray-darker" ><?php echo Str::limit($video->video_description, 120, ' ...'); ?></p>

                                                <div class="statusv-<?php echo e($video->status); ?>">
                                                    <?php echo e(($video->status=='approved' ? 'Approved':'Waiting for approval')); ?>

                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <?php else: ?>

                        You don’t have a coach video yet.
                    <?php endif; ?>
                </div>
            </div>


        </div>

        <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-body mb-0 p-0">
                        <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                            <iframe class="embed-responsive-item vim_iframe"
                                    src="" width="640" height="360"
                                    frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                        </div>
                    </div>
                    <div class="modal-footer">

                        <button class="btn-custom color-two"
                                data-dismiss="modal" type="button">Close
                        </button>
                    </div>
                </div>
            </div>
        </div>


    </div>
    </div>
<?php $__env->stopSection(); ?>
<?php if(Auth::check()): ?>
    <?php if(auth()->check() && auth()->user()->hasRole('coach')): ?>
    <?php $__env->startPush('scripts'); ?>

        <script src="/js/bo.js"></script>

    <?php $__env->stopPush(); ?>
    <?php endif; ?>

<?php endif; ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ivigoo/html/development/resources/views/coaches/profile.blade.php ENDPATH**/ ?>