<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <!-- Metas Basic -->
    <meta http-equiv="content-type" content="text/html;charset=utf-8" />
    <meta name="description"
          content="IVIGGO has a vision of developing a Danish and over time a global visual video website focusing on personal development and growth." />
    <meta name="keywords"
          content="Video coachng, Personal Development, Personal development, Self-confidence and self-esteem, Concerns and fears" />
    <meta name="author" content="Saba Qadir" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- Title -->
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">

    <?php echo $__env->make('partials.app.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <script>
        var site_config = {
            base_url: '<?= url('/') ?>'
        }
    </script>
</head>

<body>
<section class="loginpage " id="login-header">
    <div class="top-signup">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4 col-4">
                    <div class="logo-signup "><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('images/logo.svg')); ?>" alt="Logo"></a></div>
                </div>
                <div class="col-md-8 col-8 text-right">

                    <div class="custom-page-top auth-header" >
                        <?php if(Request::is('signup/*') || Request::is('coach/signup') || Request::is('thanks/*') || Request::is('password/*')): ?>
                            har du allerede en bruger? <a href="<?php echo e(route('login')); ?>" class="memberlink">Log på</a>
                        <?php endif; ?>

                       
                    </div>

                </div>
            </div>

        </div>
    </div>
    <?php echo $__env->yieldContent('content'); ?>
</section>

<!-- #footer area start -->
<?php echo $__env->make('partials.app.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- #footer area end -->
<?php echo $__env->make('partials.app.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>


<?php /**PATH /home/ivigoo/html/development/resources/views/layouts/auth.blade.php ENDPATH**/ ?>