<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta name="viewport" content="width=device-width" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Billing invoices </title>

</head>
<style>/* -------------------------------------
    GLOBAL
    A very basic CSS reset
------------------------------------- */
    * {
        margin: 0;
        padding: 0;
        font-family: "Helvetica Neue", "Helvetica", Helvetica, Arial, sans-serif;
        box-sizing: border-box;
        font-size: 14px;
    }

    img {
        max-width: 100%;
    }

    body {
        -webkit-font-smoothing: antialiased;
        -webkit-text-size-adjust: none;
        width: 100% !important;
        height: 100%;
        line-height: 1.6;
    }

    /* Let's make sure all tables have defaults */
    table td {
        vertical-align: top;
    }

    /* -------------------------------------
        BODY & CONTAINER
    ------------------------------------- */
    body {
        background-color: #f6f6f6;
    }

    .body-wrap {
        background-color: #f6f6f6;
        width: 100%;
    }

    .container {
        display: block !important;
        max-width: 600px !important;
        margin: 0 auto !important;
        /* makes it centered */
        clear: both !important;
    }

    .content {
        max-width: 600px;
        margin: 0 auto;
        display: block;
        padding: 20px;
    }

    /* -------------------------------------
        HEADER, FOOTER, MAIN
    ------------------------------------- */
    .main {
        background: #fff;
        border: 1px solid #e9e9e9;
        border-radius: 3px;
    }

    .content-wrap {
        padding: 20px;
    }

    .content-block {
        padding: 0 0 20px;
    }

    .header {
        width: 100%;
        margin-bottom: 20px;
    }

    .footer {
        width: 100%;
        clear: both;
        color: #999;
        padding: 20px;
    }
    .footer a {
        color: #999;
    }
    .footer p, .footer a, .footer unsubscribe, .footer td {
        font-size: 12px;
    }

    /* -------------------------------------
        TYPOGRAPHY
    ------------------------------------- */
    h1, h2, h3 {
        font-family: "Helvetica Neue", Helvetica, Arial, "Lucida Grande", sans-serif;
        color: #000;
        margin: 40px 0 0;
        line-height: 1.2;
        font-weight: 400;
    }

    h1 {
        font-size: 32px;
        font-weight: 500;
    }

    h2 {
        font-size: 24px;
        font-weight: bold;
    }

    h3 {
        font-size: 18px;
    }

    h4 {
        font-size: 14px;
        font-weight: 600;
    }

    p, ul, ol {
        margin-bottom: 10px;
        font-weight: normal;
    }
    p li, ul li, ol li {
        margin-left: 5px;
        list-style-position: inside;
    }

    /* -------------------------------------
        LINKS & BUTTONS
    ------------------------------------- */
    a {
        color: #1ab394;
        text-decoration: underline;
    }

    .btn-primary {
        text-decoration: none;
        color: #FFF;
        background-color: #1ab394;
        border: solid #1ab394;
        border-width: 5px 10px;
        line-height: 2;
        font-weight: bold;
        text-align: center;
        cursor: pointer;
        display: inline-block;
        border-radius: 5px;
        text-transform: capitalize;
    }

    /* -------------------------------------
        OTHER STYLES THAT MIGHT BE USEFUL
    ------------------------------------- */
    .last {
        margin-bottom: 0;
    }

    .first {
        margin-top: 0;
    }

    .aligncenter {
        text-align: center;
    }

    .alignright {
        text-align: right;
    }

    .alignleft {
        text-align: left;
    }

    .clear {
        clear: both;
    }

    /* -------------------------------------
        ALERTS
        Change the class depending on warning email, good email or bad email
    ------------------------------------- */
    .alert {
        font-size: 16px;
        color: #fff;
        font-weight: 500;
        padding: 20px;
        text-align: center;
        border-radius: 3px 3px 0 0;
    }
    .alert a {
        color: #fff;
        text-decoration: none;
        font-weight: 500;
        font-size: 16px;
    }
    .alert.alert-warning {
        background: #f8ac59;
    }
    .alert.alert-bad {
        background: #ed5565;
    }
    .alert.alert-good {
        background: #1ab394;
    }

    /* -------------------------------------
        INVOICE
        Styles for the billing table
    ------------------------------------- */
    .invoice {
        margin: 5px auto;
        text-align: left;
        width: 80%;
    }
    .invoice td {
        padding: 5px 0;
    }
    .invoice .invoice-items {
        width: 100%;
    }
    .invoice .invoice-items td {
        border-top: #eee 1px solid;
    }
    .invoice .invoice-items .total td {
        border-top: 2px solid #333;
        border-bottom: 2px solid #333;
        font-weight: 700;
    }

    /* -------------------------------------
        RESPONSIVE AND MOBILE FRIENDLY STYLES
    ------------------------------------- */
    @media  only screen and (max-width: 640px) {
        h1, h2, h3, h4 {
            font-weight: 600 !important;
            margin: 20px 0 5px !important;
        }

        h1 {
            font-size: 22px !important;
        }

        h2 {
            font-size: 18px !important;
        }

        h3 {
            font-size: 16px !important;
        }

        .container {
            width: 100% !important;
        }

        .content, .content-wrap {
            padding: 10px !important;
        }

        .invoice {
            width: 100% !important;
        }
    }
</style>
<body>

<table class="body-wrap">
    <tr>
        <td></td>
        <td class="container" width="600">
            <div class="content">
                <table class="main" width="100%" cellpadding="0" cellspacing="0">
                    <tbody>
                    <tr>
                        <td class="content-wrap aligncenter">
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tbody>
                                <tr>
                                    <td align="center" style="padding-left: 53px;">
                                        <img src="https://iviggo.com/images/logo.svg" alt="wise" height="60" style="display:block;line-height:1px;border:0;/* align-content: center; *//* align-items: center; */" oncontextmenu="return true;" onmousedown="return true;" onmouseup="return true;" onselectstart="return true;">
                                    </td>
                                </tr>

                                <tr>
                                    <td class="content-block">
                                        <h2>Aftale</h2>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="content-block">
                                        <table class="invoice">
                                            <tbody>
                                            <br>
                                            <tr>
                                                <td>
                                                    <h4>Virksomhedsoplysninger</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Firmanavn: <?php echo e($company_name); ?> <br>
                                                    Firma E-mail: <?php echo e($company_email); ?> <br>
                                                    Firmaets hjemmeside: <?php echo e($company_website); ?> <br>
                                                    Adresse: <?php echo e($address); ?>  <?php echo e($address_line_2); ?> <br>
                                                    <?php if(isset($mobile)): ?>Mobilnummer: <?php echo e($mobile); ?> <br><?php endif; ?>
                                                    Land: <?php echo e($country_name); ?> <br>
                                                    <?php if(isset($zip_code)): ?>Postnummer: <?php echo e($zip_code); ?></td><?php endif; ?>
                                            </tr>

                                            <tr>
                                                <td>
                                                    <h4>Kontaktpersonoplysninger</h4>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    Navn: <?php echo e($first_name); ?>  <?php echo e($last_name); ?><br>
                                                    E-mail: <?php echo e($email); ?> <br>
                                                    <?php if(isset($mobile_number)): ?>Mobilnummer: <?php echo e($mobile_number); ?><br><?php endif; ?>
                                                </td>
                                            </tr>
                                            <tr>

                                            </tr>

                                            <tr>
                                                <td>
                                                    <table class="invoice-items" cellpadding="0" cellspacing="0">
                                                        <tbody>
                                                        <tr>
                                                            <td>Start Dato </td>
                                                            <td class="alignright"><?php echo e(\Illuminate\Support\Carbon::parse($start_date)->format('d-m-Y')); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Slut Dato </td>
                                                            <td class="alignright"><?php echo e(\Illuminate\Support\Carbon::parse($end_date)->format('d-m-Y')); ?></td>
                                                        </tr>


                                                        <tr>
                                                            <td>Medlemmer</td>
                                                            <td class="alignright"><b><?php echo e($no_of_members); ?></b></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Månedligt pr Medarbejder </td>
                                                            <td class="alignright">kr. <?php echo e($monthly); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Arligt </td>
                                                            <td class="alignright">kr. <?php echo e($annually); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Aftalt Pris </td>
                                                            <td class="alignright">kr. <?php echo e($agreed_price); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Moms (<?php echo e($vat_rate); ?>%)</td>
                                                            <td class="alignright"><?php echo e(($agreed_price*($vat_rate/100))); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td>Total pris(kr.)</td>
                                                            <td class="alignright">kr. <?php echo e($agreed_price+($agreed_price*($vat_rate/100))); ?></td>
                                                        </tr>
                                                        
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>

                                <tr>
                                    <td class="content-block">Iviggo online videocoaching</td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
                <div class="footer">
                    <table width="100%">
                        <tbody>
                        <tr>

                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </td>
        <td></td>
    </tr>
</table>

</body>

</html>
<?php /**PATH /home/ivigoo/html/development/resources/views/pages/generate_pdf_admin.blade.php ENDPATH**/ ?>