@php

    $collectionOfRoles = ['coach','superadmin'];
    $adminRoles = ['superadmin'];
    $coachOnly = ['coach'];
    $mixedUsers = ['coach','user'];
    $allroles = ['coach','user', 'superadmin'];


@endphp
<header id="header" class="sticky transparent-header ">
    <div class="topheader top_header_light topBar ">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-4 content-center-mobile mb-1">
                    <div class="address-icon"><a href="tel:+45 42217569"><i class="fas fa-phone"></i>+45 42217569</a></div>
                    <div class="address-icon"><a href="mailto:support@iviggo.com"><i class="fas fa-envelope"></i>support@iviggo.com</a></div>
                </div>
                @if (Auth::check())

                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                            @hasrole($coachOnly)
                            <a href="{{route('company.get')}}" >Register a Company</a>
                            @endhasrole
                            @hasrole($adminRoles)
                            <a href="{{route('company.get')}}" >View Companies</a>
                            @endhasrole
                            {{--{{ ucwords(Auth::user()->first_name.' '.Auth::user()->last_name) }}--}}
                            {{-- @hasanyrole($allroles)
                             <a href="{{ config('app.marketing_url') }}" target="_blank"><i class="fas fa-arrow-alt-circle-right"></i>Affiliate Partners</a>
                             @endhasanyrole--}}
                            @hasanyrole($collectionOfRoles)

                            <a href="{{route('video.upload')}}"><i class="fas fa-plus-circle"></i>Upload Video</a>

                            <a href="{{route('coach.dashboard')}}"><i class="fas fa-user-cog"></i>My Profile</a>
                            @endhasanyrole
                            @hasrole('user')
                            <a href="{{route('users.edit')}}"><i class="fas fa-user-cog"></i>My Profile</a>
                            @endhasrole
                            <a href="javascript:void(0)" id="logout">
                                <i class="fas fa-user-circle "></i>Logout</a></div>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            {{ csrf_field() }}
                        </form>


                    </div>


                @else
                    <div class="col-lg-8 col-md-8 content-center-mobile text-right">
                        <div class="custom-page-top">
                            {{-- <a href="{{ config('app.marketing_url') }}" target="_blank"><i class="fas fa-arrow-alt-circle-right"></i>Affiliate partner</a>--}}
                            <a href="{{ route('join') }}"><i class="fas fa-plus-circle"></i>{{__('Join Now')}}</a><a
                                href="{{ route('login') }}"><i
                                    class="fas fa-user-circle "></i>{{__('Login')}}</a></div>

                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- #navigation start -->
    <nav class="navbar navbar-default navbar-expand-md navbar-light" id="navigation" data-offset-top="1">
        <!-- .container -->
        <div class="container">
            <!-- Logo and Menu -->
            <div class="navbar-header">
                <div class="navbar-brand"><a href="{{url('/')}}"><img src="{{ asset('images/logo.svg') }}"
                                                                      alt="Logo"/></a></div>
                <!-- site logo -->
            </div>
            <!-- Menu Toogle -->
            <div class="burger-icon">
                <div class="bar1"></div>
                <div class="bar2"></div>
                <div class="bar3"></div>
            </div>
            {{--@include('partials/app/language_switcher')--}}
            <div class="collapse navbar-collapse " id="navbarCollapse">
                <ul class="nav navbar-nav ml-auto">
                    <!-- Menu Link -->
                    @if (Auth::check())
                        @hasrole('user')
                        <li>
                            <a href="{{ route('user.payments') }}" class="{{ (Route::currentRouteName()== 'user.payments') ? 'active' : '' }}">My Subscription</a>

                        </li>
                        @endhasrole
                        @hasrole('is_am')

                        <li class="subnav"><a href="#" >My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="{{route('bo.videos')}}" class="nav-link ">Approve videos </a></li>
                                <li><a href="{{route('bo.intros')}}" class="nav-link ">Approve introductory videos </a></li>
                                @hasrole('coach')
                                <li><a href="{{route('bo.coaches')}}" class="nav-link ">Coach Applications </a></li>
                                @endhasrole
                            </ul>
                        </li>

                        @endhasrole

                        @hasrole('superadmin')
                        <li class="subnav">
                            <a href="#" class="{{ (strpos(Route::currentRouteName(), 'bo') === false) ? '' : 'active' }}">My Admin Panel</a>
                            <ul class="sub-menu">
                                <li><a href="{{ route('bo.videos') }}" class="nav-link ">Approve videos ({{getPendingVideosCount()}})</a></li>
                                <li><a href="{{ route('bo.intros') }}" class="nav-link ">Approve introductory videos ({{getPendingIntrosCount()}})</a></li>
                                <li><a href="{{route('bo.coaches')}}" class="nav-link ">Coach Applications ({{getPendingCoachesCount()}})</a></li>
                                <li><a href="{{route('manage.members')}}" class="nav-link ">Manage members</a></li>
                                <li><a href="{{route('bo.pages')}}" class="nav-link ">Manage Pages</a></li>
                                <li><a href="{{route('bo.staff')}}" class="nav-link ">Manage Staff</a></li>
                                <li><a href="{{ route('bo.categories') }}" class="nav-link ">Manage Categories</a></li>
                                <li><a href="{{route('bo.packages')}}" class="nav-link ">Manage Packages</a></li>
                                <li><a href="{{route('bo.questions')}}" class="nav-link ">Manage Questions</a></li>
                                <li><a href="{{ route('bo.payouts') }}" class="nav-link ">iviggo internal payouts</a></li>
                                {{--         <li><a href="{{ route('company.payouts') }}" class="nav-link ">iviggo internal company payouts</a></li>--}}

                            </ul>
                        </li>
                        @endhasrole


                    @endif
                    {{--      <li class="subnav">
                              <a href="#">Company Package</a>
                              <ul class="sub-menu">
                                  <li><a href="{{ asset('documents/company-package Eng.pdf') }}" target="blank">Company Package Eng</a></li>
                                  <li><a href="{{ asset('documents/company-package Dan.pdf') }}" target="blank">Company Package Dan</a></li>
                              </ul>
                          </li>--}}
                    <li class="subnav">
                        <a href="#">{{__('Presentation')}}</a>
                        <ul class="sub-menu">
                            <li><a href="{{ asset('documents/Iviggo_presentation Eng.pdf') }}" target="blank">iviggo presentation Eng</a></li>
                            <li><a href="{{ asset('documents/Iviggo_presentation Dan.pdf') }}" target="blank">iviggo presentation Dan</a></li>
                            <li><a href="{{ asset('documents/company-package Eng.pdf') }}" target="blank">Company Package Eng</a></li>
                            <li><a href="{{ asset('documents/company-package Dan.pdf') }}" target="blank">Company Package Dan</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="{{ route('videos') }}" class="{{ (Route::currentRouteName()=='videos') ? 'active' : '' }}">{{__('Video Library')}}</a>

                    </li>

                    <li>
                        <a href="{{ route('coaches') }}" class="{{ (Route::currentRouteName()=='coaches') ? 'active' : '' }}">{{__('Coach Panel')}}</a>

                    </li>
                    {{--    <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                {{ Config::get('languages')[App::getLocale()] }}
                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                @foreach (Config::get('languages') as $lang => $language)
                                    @if ($lang != App::getLocale())
                                        <a class="dropdown-item" href="{{ route('lang.switch', $lang) }}"> {{$language}}</a>
                                    @endif
                                @endforeach
                            </div>
                        </li>--}}

                    @hasrole('companyuser')
                    <li>
                        <a href="{{route('users.employee')}}"><i class="fas fa-user-cog"></i>My Profile</a>
                    </li>
                    @endhasrole
                    @if (Auth::check())

                        @hasanyrole($collectionOfRoles)
                        <li>
                            <a href="{{route('q.questions')}}" class="{{ (Route::currentRouteName()=='q.questions') ? 'active' : '' }}">Video Question Box</a>

                        </li>

                        @endhasanyrole
                        @hasrole('user')
                        <li>
                            <a href="{{route('questions')}}" class="{{ (Route::currentRouteName()=='questions') ? 'active' : '' }}">Video Question Box</a>

                        </li>
                        @endhasrole



                    @endif


                </ul>

            </div>
            <!-- Menu Toogle end -->
        </div>
        <!-- .container end -->
    </nav>
    <!-- #navigation end -->
</header>
