@extends('layouts.app')
@section('content')

    <!-- Pricing area start -->

    <div id="CoachQuestionBox" class="wrap-bg jn_pg">
        <div class="container">



             <div class="price-sec price-table row justify-content-around">
<div class="col-md-12 mb-4 row">
	<h3>Priser for medlemskab</h3>
				</div>
                @foreach($packages as $package)


                     <div class="col-md-4 card text-center">



                            <div class="title">
                                <h2>{{$package->title}}</h2>
                            </div>
                            <div class="price">
                                <span>Enkelt bruger</span><h4><sup>kr.</sup>{{intval($package->price)}}<small> Inkl. moms @if($package->invoice_period!='1')- per måned @endif</small></h4>

                            </div>
                            <div class="option">
                                {!!$package->description!!}
                            </div>

                            <div class="btn-section bottom-position">

                                <a href="{{ route('user.renew_package', ['id' =>$package->id ]) }}" data-id="{{$package->id}}" class="color-two join mb-2">{{$package->renew_button_text}}</a>
                                <a href="#" class="light-button" data-toggle="modal" data-target="#plan-{{$package->id}}">Prisdetaljer</a>
                                @if($package->invoice_period=='3')
                                    <p>Betal hver 3 måned uden binding</p>
                                @endif
                                @if($package->invoice_period!='3')
                                    <p>Betal hver {{($package->invoice_period=='1') ? 'måned' : 'år '}} uden binding</p>
                                @endif
                            </div>






                    </div>


                @endforeach


            </div>
        </div>
    </div>
        <!-- Pricing area end -->
@endsection

@foreach($packages as $package)
<div class="modal fade" id="plan-{{$package->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Prisdetaljer</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-striped mt-3">
                    <tbody>
                    <tr>
                        <td width="60%">{{$package->title}}</td>
                        <td width="40%">kr. {{number_format($package->price*$package->invoice_period,2)}}</td>

                    </tr>
            {{--        <tr>
                        <td>VAT ({{$vatInfo->vat_rate}}%)</td>
                        <td>€ {{number_format((($package->price*$package->invoice_period)*$vatInfo->vat_rate)/100,2)}}</td>

                    </tr>--}}
        {{--            <tr class="info">

                        <td><strong>Total</strong></td>
                        <td><strong>€ {{number_format(((($package->price*$package->invoice_period)*$vatInfo->vat_rate)/100)+($package->price*$package->invoice_period),2)}}</strong></td>

                    </tr>--}}
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="color-two btn-custom" data-dismiss="modal">Ok</button>

            </div>
        </div>
    </div>
</div>
@endforeach
