@extends('layouts.app')
@section('content')


    <!-- ApproveVideo area start -->
    <div id="UploadVideo" class="wrap-bg">

        <div class="container">

            <h3>Firma Medlemsoplysninger</h3>

            @php
                $expiring = 'No';
                $highlight = '';
                $diffInDays = Carbon::parse(Carbon::now())->floatDiffInDays($record->ends_at,false);
                if(($diffInDays < 8)) {
                    $expiring = 'Yes';
                    if($record->recurring =='inactive') {
                       $highlight = 'class=expiring';
                   }
               }
            @endphp
            <div align="right" style="padding-bottom: 15px;"><a class="color-two btn-custom" href="{{url()->previous()}}" class="btn btn-default">Afbestille</a></div>
            <div class="table table-responsive table-striped mb-3  ">
                <table class="table table-bordered ">
                    <thead>
                    <tr>
                        <th scope="col" width="15%">Firmanavn</th>
                        <th scope="col" width="10%">Pris</th>
                        <th scope="col" width="10%">Antal medlemmer</th>
                        @if($record->state=='Approved')
                            <th scope="col" width="15%">Start Dato</th>
                            <th scope="col" width="15%" {{$highlight}} data-expiring="{{$expiring}}">Slutdato</th>
                        @endif{{--
                        <th scope="col" width="10%">Status</th>--}}
                        @if($record->state=='Approved')
                             <th scope="col" width="10%">Fornyelsesstatus</th>
                        @endif
                    {{--      <th>

                          <div class="custom-control custom-switch" width="10%">
                                <input type="checkbox" {{($record->recurring=='active') ? 'checked' : ''}} class="custom-control-input" id="recSwitch" data-id="{{$record->id}}">
                                --}}{{--<label class="custom-control-label" for="recSwitch">{{($record->recurring=='active') ? 'Cancel Auto Renew' : 'Auto Renew'}}</label>--}}{{--
                            </div>

                        </th>--}}
                    </tr>
                    </thead>
                    <tbody>


                    <tr>

                        <td>{{$companyDetails->company_name}}</td>
                        <td>€{{$companyDetails->annually_per_employee}}</td>
                        <td><div contenteditable>{{$companyDetails->agreed_members}}</div></td>
                        @if($record->state=='Approved')
                            <td id="start_date" scope="col">{{Carbon::parse($record->starts_at)->format('d-m-Y')}}</td>
                            <td id="end_date" scope="col" data-expiring="{{$expiring}}"   {{$highlight}}>{{Carbon::parse($record->ends_at)->format('d-m-Y')}}</td>

                        @endif
{{--
                        <td>{{($companyDetails->state=='Approved' && $companyDetails->status=='active') ? 'Active': (empty($companyDetails->state) ? 'Awaiting Approval' : ucwords($companyDetails->status))}}</td>
--}}
                        @if($record->state=='Approved' && $diffInDays <1)
                            <td>
                                 <a class="btn btnQbox " href="{{route('company.updatetrans',['trans_id'=>$companyDetails->company_id,'renew'=>1])}}">Forny</a>
                            </td>
                        @endif
                        @if($record->state=='Approved' && $diffInDays >1)
                            <td>
                            </td>
                        @endif

                    </tr>
                    </tbody>
                </table>
            </div>
            @if(isset($record->quickpaySubscription) && $record->quickpaySubscription->count()>0)
                <h3>Transaktionshistorik</h3>
                <div class="table table-responsive table-striped mb-3 overview ">
                    <table class="table table-bordered ">
                        <thead>
                        <tr>

                            <th scope="col">Dato</th>
                            <th scope="col">Startdato for aftale</th>
                            <th scope="col">Slutdato for aftale</th>
                            <th scope="col">Aftalte medlemmer</th>
                            <th scope="col">Total</th>
                            <th scope="col">Betalings-id</th>
                            <th scope="col">Type / Status</th>


                        </tr>
                        </thead>
                        <tbody>
                        @foreach($record->quickpaySubscription as $subscription)
                            @if(isset($subscription->companyQuickpayPayments) && $subscription->companyQuickpayPayments->count()>0)
                                @foreach($subscription->companyQuickpayPayments as $payment)

                                    @php
                                        if(isset($payment->operations)) {
                                        $payOperation = json_decode($payment->operations);
                                        $info = end($payOperation);
                                        } else {
                                            $info = false;
                                        }

                                     if($payment->type == 'Payment' && $payment->state == 'Approved'){
                                        $payment->type = 'Betaling';
                                        $payment->state = 'Godkendt';
                                     }
                                    @endphp

                                    <tr style="{{ $payment->type === "Refund" ? "background-color: #e4b9c0" : "" }} ">
                                        <td>{{Carbon::parse($payment->created_at)->format('d-m-Y h:i A')}}</td>
                                        <td>{{Carbon::parse($payment->contract_start_date)->format('d-m-Y')}}</td>
                                        <td>{{Carbon::parse($payment->contract_end_date)->format('d-m-Y')}}</td>
                                        <td>{{$payment->agreed_members}}</td>
                                        <td>{{ $payment->type === "Refund" ? "-" : "" }} dkr. {{ number_format(($payment->balance),2)}}</td>
                                        <td>{{$payment->payment_id}}</td>
                                        <td>{{$payment->type}} / {{$payment->state}}</td>
                                    </tr>

                                @endforeach
                            @endif
                        @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>


    </div>

    <!-- Approve area end -->
@endsection
@push('scripts')
    {!! Html::script('js/intlTelInput.js') !!}
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        $( function() {
            var today = new Date();
            $( "#start_date, #end_date" ).datepicker({
                changeMonth: true,
                changeYear: true,
                minDate: today,
                maxDate: '+1y'
            });
        });
    </script>
@endpush
