@extends('layouts.auth')
@section('content')
    <div class="row ">
        <div class="col-md-4 py-5 text-white text-center bg-image-signup ">
            <div class=" ">
                <div class="card-body text-left">
                    <h2 class="py-3">Registrer en Virksomhed</h2>

                </div>
            </div>
        </div>

        <div class="col-lg-6 col-md-8 p-5 register-form mx-auto">

            <h4 class="pb-4">Virksomhedsoplysninger</h4>
            <form method="post"  id="company-form" action="{{ route('company.submit') }}">
                <div align="right"><a class="color-two btn-custom" href="{{url()->previous()}}" class="btn btn-default">Afbestille</a></div>
                {{ csrf_field() }}
                @include('common.flash_messages')
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="company_name" class="required">Firmanavn</label>
                        <input id="company_name" name="company[company_name]" class="form-control" type="text" value="{{old('company.company_name')}}" autocomplete="off">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="email" class="required">Firma e-mail</label>
                        <input type="text" name="company[company_email]" class="form-control" id="email"  value="{{old('company.company_email')}}" autocomplete="off">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="company_website" class="required">Firmaets hjemmeside </label>
                        <input id="company_website" name="company[company_website]" class="form-control" type="text" value="{{old('company.company_website')}}"  autocomplete="off">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="no_of_employees" class="required">Potentielt antal ansatte </label>
                        <input id="no_of_employees" name="company[no_of_employees]" class="form-control" type="text"  onkeypress="return validateNumber(event)" value="{{old('company.no_of_employees')}}" autocomplete="off">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="address" class="required">Adresse</label>
                        <input id="address" name="company[address]" class="form-control" type="text"  value="{{old('company.address')}}" autocomplete="off">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="address"> Adresselinje 2</label>
                        <input id="address" name="company[address_line_2]" class="form-control" type="text"  value="{{old('company.address_line_2')}}" autocomplete="off">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label>Telefonnummer</label>
                        <div class="mobilem signup"> <input id="phone" name="company[mobile]"  onkeypress="return validateNumber(event)" value="{{old('company.mobile')}}" class="form-control" type="text"  autocomplete="off"></div>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="first_name" class="required">Vælg land</label>

                        {{ Form::select('company[country]', [null=>'Vælg land'] + $countries, old('company.country') , ['class' => 'form-control','id'=>'country','autocomplete'=>'off']) }}

                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="required">CVR</label>
                        <input id="cvr" name="company[cvr]" value="{{old('company.cvr')}}" class="form-control" type="text"  autocomplete="off">

                    </div>
                    <div class="form-group col-md-6">
                        <label>Postnummer</label>
                        <input id="zip_code" name="company[zip_code]"  value="{{old('company.zip_code')}}" class="form-control" type="text"  autocomplete="off">

                    </div>
                </div>

                <h4 class="pb-4">Kontaktpersonoplysninger</h4>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="first_name" class="required">Fornavn</label>
                            <input id="first_name" name="company[first_name]" class="form-control" type="text"  value="{{old('company.first_name')}}" autocomplete="off">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="first_name" class="required">Efternavn</label>
                            <input type="text" class="form-control" id="last_name" name="company[last_name]"  value="{{old('company.last_name')}}" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Telefonnummer</label>
                            <div class="mobilem company"> <input id="phone2"  onkeypress="return validateNumber(event)" name="company[mobile_number]" value="{{old('company.mobile_number')}}" class="form-control" type="text"  autocomplete="off"></div>

                        </div>

                        <div class="form-group col-md-6">
                            <label for="email" class="required">E-mail</label>
                            <input id="email" name="company[email]" class="form-control" type="text" value="{{old('company.email')}}" autocomplete="off">
                        </div>
                    </div>

                <h4 class="pb-4">Aftale</h4>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="start_date" class="required">Start dato</label>
                        <input id="start_date" name="company[start_date]" class="form-control" type="text"  value="{{old('company.start_date')}}" autocomplete="off" onchange="showAgreedPrice()" readonly="" style="background-color: #ffffff">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="end_date" class="required">Slutdato</label>
                        <input id="end_date" name="company[end_date]" class="form-control" type="text"  value="{{old('company.end_date')}}" autocomplete="off"  onchange="showAgreedPrice()" readonly="">
                    </div>

                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                            <label for="no_of_members" class="required">Medlemmer (min. 10) </label>
                            <input id="no_of_members" name="company[no_of_members]"  onkeypress="return validateNumber(event)" class="form-control" type="text" value="{{old('company.no_of_members')}}" autocomplete="off" onfocusout="showAgreedPrice()">
                        </div>

                    <div class="form-group col-md-6">
                        <label for="first_name" class="required">Månedlig/ medarbejder (min. 5 ELLER maks. 20)</label>
                        <input id="monthly" name="company[monthly]" class="form-control"  onkeypress="return validateNumber(event)" type="text" autocomplete="off" value="{{old('company.monthly')}}" onfocusout="showAgreedPrice()"  onchange="showAgreedPrice()">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="annually">Årligt (kr.)</label>
                        <input id="annually" name="company[annually]" class="form-control" type="text"  onkeypress="return validateNumber(event)" autocomplete="off"  readonly>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="agreed_price">Aftalt pris (kr.)</label>
                        <input id="agreed_price" name="company[agreed_price]"  onkeypress="return validateNumber(event)" class="form-control" type="text" value="{{old('company.agreed_price')}}" autocomplete="off">
                    </div>
                </div>
                <div class="form-row pt-3 pl-1">
                    <button type="submit" class="color-two btn-custom ">Indsend</button>
                </div>
                </form>
         </div>
    </div>

@endsection



@push('styles')
    {!! Html::style('css/intlTelInput.css') !!}
@endpush
@push('scripts')
    {!! Html::script('js/intlTelInput.js') !!}
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <script>


        function validateNumber(e) {
            const pattern = /^[0-9]$/;

            return pattern.test(e.key )
        }
        $( function() {
            var today = new Date();
            $( "#start_date" ).datepicker({
                changeMonth: true,
                changeYear: true,
                minDate: today,
                maxDate: '+1y',
                onSelect: function (today) {
                    var myDate = new Date(today);
                    myDate.setFullYear(myDate.getFullYear() + 1);
                    myDate.setDate(myDate.getDate() - 1);
                    var myval = ((myDate.getMonth() + 1)+ "/" + (myDate.getUTCDate() + "/"+ myDate.getUTCFullYear()));
                    $('#end_date').val(myval);
                    $('#start_date-error').hide();
                    $('#end_date-error').hide();
                    $('#start_date').css('border-color','#ced4da');
                    $('#end_date').css('border-color','#ced4da');
                    showAgreedPrice();
                }
            });

        });

        function showAgreedPrice(){
            var noOfMemberships = $('#no_of_members').val();
            if($("#monthly").val() != '') {
                var startDate = new Date(document.getElementById('start_date').value);
                var endDate = new Date(document.getElementById('end_date').value);
                var months = (Math.max((endDate.getFullYear() - startDate.getFullYear()) * 12 + endDate.getMonth() - startDate.getMonth(), 0));
                var priceForOneMember = $("#monthly").val();
                var monthlyPrice =noOfMemberships * priceForOneMember;
                if(monthlyPrice != 0) {
                    if(startDate != 'Invalid Date') {
                        $('#agreed_price').val(months * monthlyPrice);
                        $('#annually').val(months * monthlyPrice);
                    }

                }
            }
        }
        var input = document.querySelector("#phone");
        var input2 = document.querySelector("#phone2");
        iti = intlTelInput(input, {
            formatOnDisplay: false,
            separateDialCode: true,
            autoPlaceholder: 'off',
            hiddenInput:"phone",
            autoHideDialCode:true,
            preferredCountries: ["dk"],
            utilsScript: "/js/build/js/utils.js",
        });

        iti2 = intlTelInput(input2, {
            formatOnDisplay: false,
            separateDialCode: true,
            autoPlaceholder: 'off',
            hiddenInput:"phone2",
            autoHideDialCode:true,
            preferredCountries: ["dk"],
            utilsScript: "/js/build/js/utils.js",
        });

        var oldPhone = '{{old('general.phone')}}';
        var oldPhone2 = '{{old('general.phone2')}}';
        if(typeof iti !== 'undefined' && oldPhone) {
            iti.setNumber(oldPhone);
        }
        if(typeof iti2 !== 'undefined' && oldPhone2) {
            iti.setNumber(oldPhone);
        }


    </script>
@endpush

