@extends('layouts.app')
@section('content')
    <!-- questionbox area start -->

    <div id="CoachQuestionBox" class="wrap-bg">
        <div class="container">

			<div class="row">
				<div class="col-md-8">
					<h3>Video spørgsmålsboks</h3>
				</div>
				<div class="col-md-4">
				 <div class="ask-button btn-section">
                    <!-- button call to action -->
                    <a href="#" class="color-two btn-custom askQuestion">Stil et Spørgsmål</a>
                </div>
				</div>



			<div class="col-md-12">
            @include('common.flash_messages')
            @if($questions && count($questions) > 0)
                <div class="accordion accoridianb" id="accordian">
                    @foreach($questions as $question)
                        <div class="card">
                            <div class="card-header" id="question_{{$question->id}}" class="btn btn-link" type="button"
                                 data-toggle="collapse"
                                 data-target="#collapse{{$question->id}}" aria-expanded="true"
                                 aria-controls="collapse{{$question->id}}">
                                <div class="d-flex w-100 justify-content-between">
                                    <h4>{{$question->title}}</h4>

                                    <div
                                        class="videocount">{{$question->Replies->count()}} {{  Str::plural('video',$question->Replies->count()) }}</div>

                                </div>
                                <div class="d-flex w-100 justify-content-between">
                                    <span>Kategori: <span class="">{{$question->category->title}}</span></span>
                                    <small class="time-f">
                                        @if ($question->created_at->diffInMonths(\Illuminate\Support\Carbon::now()) >= 1)
                                            {{ Carbon::parse($question->created_at)->format('d-m-Y h:i A') }}
                                        @else
                                            {{ $question->created_at->diffForHumans() }}
                                        @endif
                                    </small>

                                </div>
                            </div>

                            <div id="collapse{{$question->id}}" class="collapse {{($loop->first) ? 'show' : ''}}"
                                 aria-labelledby="question_{{$question->id}}"
                                 data-parent="#accordian">
                                <div class="card-body">
                                    <div class="container">
                                        <!-- .row -->
                                        <div class="row">
											<div class="col-md-12">
                                            	<p>{{$question->description}}</p>
										    </div>
											   @if($question->Replies->count()>0)
                                                        @foreach($question->Replies as $reply)

                                                            <div class="col-lg-3 col-md-4 col-sm-6 col-12 mt-4">

                                                                <a href="{{route('video.play',['id'=>$reply->Video->id])}}"
                                                                   class="color-gray-darker td-hover-none"
                                                                   target="_blank">
                                                                    <div class="ba-0 ds-1 like-content">
                                                                        <div class="course-viewer">
                                                                            <ul>

                                                                                <li>
                                                                                    {{ gmdate("H:i:s", $reply->Video->video_duration) }}
                                                                                </li>
                                                                            </ul>
                                                                        </div>

                                                                        <div style="background-image: url({{ asset('uploads/images/'.$reply->Video->video_thumbnail) }});" class="card-img-top"></div>

                                                                        <div class="card-body">
                                                                            @php
                                                                                $fullName = $reply->coach->first_name.' '.$reply->coach->last_name;
                                                                            @endphp
                                                                            <span class="coach-name ">{!! Str::limit($fullName, 50, ' ...') !!}
                                                        </span>
                                                                            <h4 class="card-title color-gray-darker"
                                                                                >{!! Str::limit($reply->Video->video_title, 20, ' ...') !!}
                                                                            </h4>
                                                                            <p class="card-text color-gray-darker">{!! Str::limit($reply->Video->video_description, 120, ' ...') !!}</p>

                                                                        </div>

                                                                    </div>
                                                                </a>

                                                            </div>
                                                        @endforeach
                                                    @endif
                                        </div>

                                    </div>
                                </div>
                            </div>


                        </div>
                    @endforeach

                </div>
            @else

                <div class="container"> Ingen Spørgsmål Fundet.</div>
            @endif

			</div>

                <div class="col-lg-12 col-md-12 col-sm-12">
                    {{ $questions->appends($_GET)->links() }}
                </div>
           </div>
        </div>
        <!-- questionbox area end -->
</div>
        <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-body mb-0 p-0">
                        <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                            <iframe class="embed-responsive-item vim_iframe"
                                    src="" width="640" height="360"
                                    frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                        </div>
                    </div>
                    <div class="modal-footer">

                        <button class="btn-custom color-two"
                                data-dismiss="modal" type="button">LUK
                        </button>
                    </div>
                </div>
            </div>
        </div>


    @include('partials.app.question',['refresh'=>'yes'])
@endsection
