@extends('layouts.app')
@section('content')


    <div class="lernen_banner large bg-bgcoach">


        <div class="container">
            <div class="row">
                <div class="col-md-12 mb-3">
                    <h3 class="lernen_banner_title"> {{$user->first_name}} {{$user->last_name}} </h3>
                    <div class="bar"></div>
                     @if (!empty($user->coachInfo->website))
                                @php
                                    $url = $user->coachInfo->website;
                                    if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {

                                            // If not exist then add http
                                            $url = "http://" . $url;
                                        }

                                @endphp
                                <h6>Website: <a href="{{url($url)}}"
                                              target="_blank">{{$user->coachInfo->website}}</a></h6>
                            @endif
                    <p>{{$user->coachInfo->slogan}}</p>
                </div>


            </div>
        </div>
    </div>
    <!-- end breadcrumb banner content area start -->


    <!-- services area start -->
    <div id="profile" class="wrap-bg ">
        <!-- .container -->
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-6 col-sm-6">
                    <div class="dreidbgleft pr-img" style="background-image: url({{ asset('uploads/images/'.$user->coachInfo->photo) }});" data-toggle="tooltip" data-placement="top" title="{{$user->first_name}} {{$user->last_name}}">
                    </div>
                    <div class="coachsubscribe">
                    @if(isset($subscription) && Auth::check())
                        @if($subscription==1)
                            <a class="color-two btn-custom text-center subscribe " href="#" data-id="{{$user->id}}"
                               data-type="unsubscribe">Stop Følg Coach</a>
                        @else
                            <a class="color-two btn-custom text-center subscribe " href="#" data-id="{{$user->id}}"
                               data-type="subscribe">Følg Coach</a>
                        @endif
                    @endif
                    </div>
                </div>

                <div class="col-lg-7 col-md-6 col-sm-6">
                    @include('common.flash_messages')

                            <h5>Om mig</h5>
                            <p>{{$user->coachInfo->introduction}}</p>


                            <h5>Mit Ekspertiseområde</h5>
                            <p>{{$user->coachInfo->expertise}}</p>

                            <div class="row black-text">
                                <!-- #counter -->
                                <div class="col-6 col-sm-6 col-md-4 col-lg-3">
                                    <div class="info">
                                        <!-- 1 -->
                                        <div class="themeioan_counter text-center sub_c">
                                            <!-- single counter item -->

                                            <h4>{{$user->subscribers->count()}}</h4>
                                            <p>Abonnenter</p>
                                        </div><!-- end single counter item -->
                                    </div>
                                </div>
                                <div class="col-6 col-sm-6 col-md-4 col-lg-3">
                                    <!-- .row -->
                                    <div class="info">
                                        <!-- 2 -->
                                        <div class="themeioan_counter text-center">
                                            <!-- single counter item -->

                                            <h4>{{$videos->count()}}</h4>
                                            <p>Samlede Videoer</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- .row end -->
                                <!-- #counter area end -->
                            </div>


                </div>
            </div>

            @if($intro->count()>0)
                <div class="row">
                    <div class="container mt-4">
                        <h5>Introduktionsvideoer</h5>
                        <div class="row">
                            @foreach ($intro as $key => $rec)

                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    <a data-id='{{$rec->video_id}}' href="#"
                                       class="color-gray-darker td-hover-none vimeo_play">
                                        <div class="ba-0 ds-1 like-content">


                                            <div style="background-image: url({{ asset('uploads/images/'.$rec->video_thumbnail) }});" class="card-img-top"></div>
                                            <div class="card-body">
                                                @php
                                                    $fullName = $user->first_name.' '.$user->last_name;
                                                @endphp
                                                <span class="coach-name " >{!! Str::limit($fullName, 50, ' ...') !!}
                                                        </span>
                                                <h4 class="card-title color-gray-darker" >{!! Str::limit($rec->video_title, 35, ' ...') !!}
                                                </h4>
                                                <p class="card-text color-gray-darker" >{!! Str::limit($rec->video_description, 120, ' ...') !!}</p>
                                                   <div class="course-viewer">
                                                    <ul>

                                                        <li>
                                                            <i class="fas fa-clock"></i> {{ gmdate("H:i:s", $rec->video_duration) }}
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>

                            @endforeach
                        </div>
                    </div>
                </div>

            @endif

            <div class="row">
                <div class="container mt-4">
                    <h5>Videoer fra {{$user->first_name}} {{$user->last_name}}</h5>
                    @if(count($videos)>0)
                        <div class="row">


                            @foreach($videos as $video)
                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    @if (Auth::check())
                                        @if($video->is_favorite==true)
                                        <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite favorited" data-id="{{$video->id}}" data-type="unfavorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Fjern Fra Favorit</span> </a> </div>
                                        @else
                                        <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite" data-id="{{$video->id}}" data-type="favorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Føj til Favorit</span> </a> </div>
                                        @endif
                                        <a href="{{route('video.play',['id'=>$video->id])}}" target="_blank"
                                           class="color-gray-darker td-hover-none ">

                                    @else
                                        <a data-id='login' href="#"
                                            class="color-gray-darker td-hover-none lg_in">
                                    @endif
                                                    <div class="ba-0 ds-1 like-content">


                                                        <div style="background-image: url({{ asset('uploads/images/'.$video->video_thumbnail) }});" class="card-img-top"></div>
                                                        <div class="card-body">
                                                            @php
                                                                $fullName = $video->user->first_name.' '.$video->user->last_name;
                                                            @endphp
                                                            <span class="coach-name " >{!! Str::limit($fullName, 50, ' ...') !!}
                                                        </span>
                                                            <h4 class="card-title color-gray-darker">{!! Str::limit($video->video_title, 20, ' ...') !!}
                                                            </h4>
                                                            <p class="card-text color-gray-darker">{!! Str::limit($video->video_description, 120, ' ...') !!}</p>
                                                            <div class="course-viewer">
                                                                <ul>
                                                                    <li>
                                                                        <i class="fas fa-clock"></i> {{ gmdate("H:i:s", $video->video_duration) }}
                                                                    </li>
                                                                </ul>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </a>
                                </div>
                            @endforeach

                        </div>
                    @else

                        Ingen Videoer Fundet.
                    @endif
                </div>
            </div>
        </div>

        <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1"
             style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-body mb-0 p-0">
                        <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                            <iframe class="embed-responsive-item vim_iframe"
                                    src="" width="640" height="360"
                                    frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                        </div>
                    </div>
                    <div class="modal-footer">

                        <button class="btn-custom color-two"
                                data-dismiss="modal" type="button">LUK
                        </button>
                    </div>
                </div>
            </div>
        </div>


    </div>
    </div>
@endsection
@if (Auth::check())
    @hasrole('coach')
    @push('scripts')

        <script src="/js/bo.js"></script>

    @endpush
    @endhasrole

@endif
