@extends('layouts.app')
@section('content')
    <div class="lernen_banner large bg-project2">


        <div class="container">
            <div class="row">
                <div class="lernen_banner_title">
                    <h1>Videobibliotek</h1>
          {{--          <h4>Search in the video library where we focus on inspiring you <br>
   with positive solutions to your everyday challenges and <br>
                  problems as a private person or workwise<br><br>
                  Or write directly to the coach panel who will respond to you with videos

</h4>--}}
                    <h4>
                        Søg altid først i videobiblioteket, hvor vi fokuserer på at inspirere <br>dig med positive løsninger på dine hverdagsudfordringer og <br>problemer som privatperson eller arbejdes relateret<br><br>
                        Hvis du ikke finder det du søger så skriv til ekspertpanelet, som<br>svarer dig med videoer
                    </h4>
                    <br>
                    <br>
                    <div class="button-section"><a href="/questions" class="color-two btn-custom">Spørg her</a></div>

                </div>
            </div>
        </div>
    </div>

    <div class="library-filter mb20">
        <div class="container">

            <form action="{{route('videos.filter')}}" id="filter_form">

                <div class="row ">

                    <div class="col-md-4 col-sm-4 mt-1 mb-1">
                        {{ Form::select('category', [null=>'Søg efter kategorier'] + $categories, isset($category) ? $category : null , ['class' => 'form-control filter ']) }}


                    </div>
                    <div class="col-md-4 col-sm-4 mt-1 mb-1">
                        {{ Form::select('language', [null=>'Søg efter sprog'] + $languages, isset($language) ? $language : null , ['class' => 'form-control filter']) }}

                    </div>
<!--                    <div class="col-sm-3">


                    </div>-->
                    @if (Auth::check())
                        <div class="col-md-4 col-sm-4 mt-1 mb-1">
                            {{ Form::select('type', $types, isset($type) ? $type : null , ['class' => 'form-control filter']) }}


                        </div>
                    @endif


                </div>
            </form>
        </div>
    </div>



        <div class="container">
            <!-- .row -->
            <div class="row">

                <div class="container mt-2">
                    @include('common.flash_messages')
                    @if(count($videos)>0)
                        <div class="row">

                                @foreach($videos as $video)
                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12">

                                        @if (Auth::check())

                                            @if($video->is_favorite==true)
                                            <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite favorited" data-id="{{$video->id}}" data-type="unfavorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Remove from Favorite</span> </a> </div>
                                            @else
                                            <div class="expand_button"> <a href="#" class="btn e-button btn-sm  favorite" data-id="{{$video->id}}" data-type="favorite"> <span class="e-button-text"><i class="fa fa-heart " style="padding-right:3px;"></i> Add to Favorite</span> </a> </div>
                                            @endif


                                        <a href="{{route('video.play',['id'=>$video->id])}}" class="color-gray-darker td-hover-none" target="_blank">
                                        @else
                                         <a data-id='login' href="#" class="color-gray-darker td-hover-none lg_in">
                                        @endif
                                            <div class="ba-0 ds-1 like-content">
                                            <div class="course-viewer">
                                                        <ul>

                                                            <li>
                                                                {{ gmdate("H:i:s", $video->video_duration) }}
                                                            </li>
                                                        </ul>
                                                    </div>

                                                <div style="background-image: url({{ asset('uploads/images/'.$video->video_thumbnail) }});" class="card-img-top"></div>
                                                <div class="card-body">
                                                        @php
                                                            $fullName = $video->user->first_name.' '.$video->user->last_name;
                                                        @endphp
                                                        <span class="coach-name " >{!! Str::limit($fullName, 50, ' ...') !!}
                                                        </span>
                                                    <h4 class="card-title color-gray-darker"   >{!! Str::limit($video->video_title, 50, ' ...') !!}
                                                    </h4>
                                                    <p class="card-text color-gray-darker" >{!! Str::limit($video->video_description, 120, ' ...') !!}</p>

                                                </div>
                                            </div>
                                        </a>

                                    </div>
                                @endforeach


                        </div>
                    @else

                        No Videos Found.
                    @endif
                    </div>

                </div>
                <!-- .row end -->
                <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT" role="dialog" tabindex="-1"
                     style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body mb-0 p-0">
                                <div class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                                    <iframe class="embed-responsive-item vim_iframe"
                                            src="" width="640" height="360"
                                            frameborder="0" allow="autoplay; fullscreen" allowfullscreen=""></iframe>

                                </div>
                            </div>
                            <div class="modal-footer">

                                <button class="btn-custom color-two"
                                        data-dismiss="modal" type="button">Close
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        {{ $videos->appends($_GET)->links() }}
                    </div>
                </div>

            </div>




@endsection



