@extends('layouts.app')
@section('content')
    <!-- questionbox area start -->

    <div id="CoachQuestionBox" class="wrap-bg">
        <div class="container">
            <h3>Video spørgsmålsboks</h3>
            @include('common.flash_messages')
            @if($questions && count($questions) > 0)
                <div class="list-group">
                    @foreach($questions as $question)
                        <div
                            class="list-group-item list-group-item-action  {{($question->Replies->count()>0) ? '' : 'active'}}"
                            id="qitem-{{$question->id}}">
                            <div class="d-flex w-100 justify-content-between align-items-center">
                                <h4>{{$question->title}}</h4>

                                <div class="videoid">Id: {{$question->id}}</div>

                            </div>
                            <div class="d-flex w-100 justify-content-between">
                                <span>Category: <span class="">{{$question->category->title}}</span></span>
                                <small class="time-f">
                                    @if ($question->created_at->diffInMonths(\Illuminate\Support\Carbon::now()) >= 1)
                                        {{ Carbon::parse($question->created_at)->format('d-m-Y h:i A') }}
                                    @else
                                        {{ $question->created_at->diffForHumans() }}
                                    @endif
                                </small>

                            </div>
                            <p>{{$question->description}}</p>
                            <div class="row " style="{{($question->Replies->count()>0) ? 'display:none' : ''}}">
                                <div class="col-md-12 answith">


                                    <span><strong>Svar med:</strong></span>

                                    <a href="{{route('video.upload', $question->id)}}" class="btn  btnQbox ">Upload
                                        Video</a>
                                    <a href="#" class="btn  btnQbox qsel"
                                       data-id="{{$question->id}}">Vælg Fra Galleri
                                    </a>

                                </div>
                            </div>
                        </div>
                    @endforeach


                </div>
            @else

                Ingen Spørgsmål Fundet.
            @endif
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    {{ $questions->appends($_GET)->links() }}
                </div>
            </div>
        </div>
    </div>
    <!-- questionbox area end -->

    <!-- Modal -->
    <div class="modal fade" id="q_Answer" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Vælg fra Galleri</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="SelectLibrary" class="wrap-bg">
                        <div class="container">
                            <!-- .row -->
                            <div class="row">
                                <div class="container mt-4">
                                    @if($videos->count() > 0)
                                        <div class="row">
                                            @foreach($videos as $video)
                                                <div class="col-md-6">
                                                    <div class="checkbox">
                                                        <input type="checkbox" name='videos[]' class="s_q_v"
                                                               value="{{$video->id}}">
                                                    </div>
                                                    <a data-id='{{$video->video_id}}' href="#"
                                                       class="color-gray-darker td-hover-none vimeo_play">
                                                        <div class="ba-0 ds-1 like-content">
                                                            <div class="course-viewer">
                                                                <ul>

                                                                    <li>
                                                                        {{ gmdate("H:i:s", $video->video_duration) }}
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div
                                                                style="background-image: url({{ asset('uploads/images/'.$video->video_thumbnail) }});"
                                                                class="card-img-top"></div>
                                                            <div class="card-body">
                                                <span
                                                    class="coach-name  ">{{$video->user->first_name}} {{$video->user->last_name}}
                                                </span>
                                                       <h4 class="card-title color-gray-darker line-clamp line-clamp-3">{{$video->video_title}}
                                                                </h4>
                                                                <p class="card-text color-gray-darker">{!! Str::limit($video->video_description, 90, ' ...') !!}</p>
                                                            </div>
                                                        </div>
                                                    </a>

                                                </div>
                                            @endforeach
                                        </div>
                                        <div aria-labelledby="myModalLabel" class="modal fade" id="modalYT"
                                             role="dialog" tabindex="-1"
                                             style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-body mb-0 p-0">
                                                        <div
                                                            class="embed-responsive embed-responsive-16by9 z-depth-1-half">
                                                            <iframe class="embed-responsive-item vim_iframe"
                                                                    src="" width="640" height="360"
                                                                    frameborder="0" allow="autoplay; fullscreen"
                                                                    allowfullscreen=""></iframe>

                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">

                                                        <button
                                                            class="btn btn-outline-primary btn-rounded btn-md ml-4 text-center"
                                                            data-dismiss="modal" type="button">LUK
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <p>Ingen tilgængelige videoer.</p>
                                    @endif
                                </div>
                            </div>
                            <!-- .row end -->
                        </div>
                    </div>
                </div>
                @if($videos->count() > 0)
                    <div class="modal-footer">

                        <button type="button" data-id="" class="btn  btnQbox" id="q_videos">SENDE</button>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <!-- end Modal -->
@endsection
