@extends('layouts.app')
@section('content')

    <!-- ApproveVideo area start -->
    <div id="UploadVideo" class="wrap-bg">

        <div class="container">
            @if(isset($record->id))
                <h3>Edit iviggo Staff</h3>
            @else
                <h3>Add iviggo Staff</h3>
            @endif


            <div class=" mt-4">
                <div class="row">

                    <div class="col-sm-12  mb-4">
                        <form method="post" enctype="multipart/form-data" id="staff-form-submit"
                              action="{{ route('bo.staff.submit') }}">
                            {{ csrf_field() }}
                            @if(isset($record->id))
                                <input type="hidden" name="id" value="{{$record->id}}">
                            @endif
                            @include('common.flash_messages')
                            <div class="form-group">
                                <label for="speakerProfilePicInput2">Picture</label>
                                <input name="photo" type="file" class="form-control-file"
                                       id="speakerProfilePicInput2">
                            </div>
                            @if(isset($record->photo))
                                <div class="form-group">
                                    <a href="{{asset('uploads/images/'.$record->photo)}}" target="_blank"
                                       class="memberlink">View Image</a>
                                </div>
                            @endif
                            <div class="form-group">
                                <label for="Name">Name</label>
                                <input type="text" class="form-control" id="staffName" name="title"
                                       value="{{(isset($record->title) ? $record->title:old('title'))}}">

                            </div>
                            <div class="form-group">
                                <label for="Description">Description</label>
                                <input type="Text" class="form-control" id="DescriptionStaff" name="description"
                                       value="{{(isset($record->description) ? $record->description:old('description'))}}">
                            </div>

                            @if(isset($record->id))
                                <button type="submit" class="color-two btn-custom ">Update</button>
                            @else
                                <button type="submit" class="color-two btn-custom ">Add</button>
                            @endif
                        </form>
                    </div>
                </div>
            @if(!isset($record->id))
                <!-- .row -->
                    <div class="row">
                        @if($staff && count($staff)>0)
                            @foreach($staff as $item)

                                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                                    <div class="iconsets">

                                        <button data-toggle="tooltip" data-placement="right" title="Edit Member" class="statusactive co_staff" data-id="{{ $item->id}}" data-type="edit"><i class=" fas fa-pencil-alt " aria-hidden="true"></i></button>
                                        <button data-toggle="tooltip" data-placement="right" title="Delete Member" class="statusdeactive co_staff" aria-hidden="true" data-id="{{ $item->id}}" data-type="remove"><i class="fa fa-trash " ></i>
                                        </button>

                                    </div>

                                        <div class="ba-0 ds-1 like-content">

                                            <div style="background-image: url({{ asset('uploads/images/'.$item->photo) }});" class="blog-photo"></div>
                                            <div class="card-body">

                                                <h4 class="card-title color-gray-darker" >{{$item->title}}
                                                </h4>
                                                <p class="card-text color-gray-darker" >{!! Str::limit($item->description, 120, ' ...') !!}</p>

                                            </div>
                                        </div>



                                </div>


                            @endforeach
                        @endif

                    </div>
                    <!-- .row end -->
                @endif


            </div>


        </div>


    </div>


    <!-- Approve area end -->


@endsection
@push('scripts')

    <script>

        $(document).ready(function () {
            $(document).on('click','.co_staff',function(e) {
                e.preventDefault();
                id = $(this).data('id');
                type = $(this).data('type');
                if(type=='edit') {
                    location.href=site_config.base_url + "/bo/staff/"+id;
                }

                if(type=='remove') {
                    location.href=site_config.base_url + "/bo/staff/delete/"+id;
                }

            });
        });
    </script>
@endpush
