@extends('layouts.app')
@section('content')

    <!-- ApproveVideo area start -->
    <div id="UploadVideo" class="wrap-bg">

        <div class="container">

            <h3>CMS Pages</h3>


            <div class="table-responsive mb-3 overview">
                @if($pages->count() > 0)
                    <table class="table table-striped table-bordered dt-responsive action-it nowrap" style="width:100%" id="tableOne">
                    <thead>
                    <tr>
                        <th>Page Title</th>
                        <th>Page Link</th>
                        <th>Last Updated</th>
                        <th style="width: 20px;"> Actions</th>


                    </tr>
                    </thead>
                    <tbody>
                    @foreach($pages as $page)
                    <tr>
                        <td>{{$page->title}}</td>
                        @if($page->website=='affiliate')
                            <td><a href="{{getenv('MARKETING_URL').'/'.$page->slug}}" target="_blank">{{$page->slug}}</a></td>
                        @else
                            <td><a href="{{url($page->slug)}}" target="_blank">{{$page->slug}}</a></td>
                        @endif
                        <td>{{Carbon::parse($page->updated_at)->format('d-m-Y')}}</td>


                        <td class="text-center">


                            <a href="{{route('bo.page.edit',['id'=>$page->id])}}" ><i class=" fas fa-pencil-alt " aria-hidden="true"></i></a>



                        </td>

                    </tr>
                    @endforeach




                    </tbody>
                </table>
                    @else

                No Records Found!
                    @endif


            </div>


        </div>

        <div class="container">

            <h3>Presentation Pages</h3>


            <div class="table-responsive mb-3 overview">
                @if($presentations->count() > 0)
                    <table class="table table-striped table-bordered dt-responsive action-it nowrap" style="width:100%" id="tableOne">
                        <thead>
                        <tr>
                            <th>Page Title</th>
                            <th>Language</th>
                            <th>Page Link</th>
                            <th>Last Updated</th>
                            <th>Actions</th>


                        </tr>
                        </thead>
                        <tbody>
                        @foreach($presentations as $page)
                            <tr>
                                <td>{{$page->title}}</td>
                                <td>{{$page->language}}</td>
                                <td><a href="{{getenv('MARKETING_URL').'/'.$page->slug}}" target="_blank">{{$page->slug}}</a></td>
                                <td>{{Carbon::parse($page->updated_at)->format('d-m-Y')}}</td>


                                <td class="text-center">

                                    <a href="{{route('bo.page.edit',['id'=>$page->id,'type'=>'mkt'])}}" ><i class=" fas fa-pencil-alt " aria-hidden="true"></i></a>


                                </td>

                            </tr>
                        @endforeach




                        </tbody>
                    </table>
                @else

                    No Records Found!
                @endif


            </div>


        </div>


    </div>

    <!-- Approve area end -->


@endsection
