@extends('layouts.app')
@section('content')

    <!-- ApproveVideo area start -->
    <div id="UploadVideo" class="wrap-bg">

        <div class="container">
            <div class="table-responsive mb-3 overview">
                @if(session()->has('message'))
                    <div class="alert alert-success">
                        {{ session()->get('message') }}
                    </div>
                @endif
                @if(session()->has('errmessage'))
                    <div class="alert alert-warning">
                        {{ session()->get('errmessage') }}
                    </div>
                @endif
            <h3>Member Packages</h3>
            <div style="padding-bottom: 15px" align="right">
                <a href="{{route('bo.package.create')}}" class="color-two btn-custom">Add Package</a>
            </div>
            <div class="table-responsive mb-3 overview">
                @if($packages->count() > 0)
                    <table class="table table-bordered table-responsive-stack action-it" id="tableOne">
                    <thead>
                    <tr>
                        <th>Title</th>
                        <th>Price</th>
                        <th>Duration</th>
                        <th>Last Updated</th>
                        <th style="width: 20px;"> Actions</th>


                    </tr>
                    </thead>
                    <tbody>
                    @foreach($packages as $package)
                    <tr>
                        <td>{{$package->title}}</td>
                        <td>{{$package->price}}</td>
                        <td>{{$package->invoice_period}} {{$package->invoice_interval}}</td>
                        <td>{{Carbon::parse($package->updated_at)->format('d-m-Y')}}</td>

                        <td class="text-center">

                            <a href="{{route('bo.package.edit',['id'=>$package->id])}}" ><i class=" fas fa-pencil-alt " aria-hidden="true"></i></a>
                            <a href="{{route('bo.package.delete',['id'=>$package->id])}}" ><i class=" fas fa-trash " aria-hidden="true"></i></a>

                        </td>

                    </tr>
                    @endforeach




                    </tbody>
                </table>
                    @else

                No Records Found!
                    @endif


            </div>


        </div>


    </div>

    <!-- Approve area end -->


@endsection
