@extends('layouts.app')
@section('content')

    <div id="member-overview" class="wrap-bg">

        <div class="container">


            <div class="container p-0">
                <div class="row">
                    <div class="col-md-6 col-lg-8">
                        <h3>Medlemsoversigt</h3>
                    </div>
                    <div class="col-md-3 col-lg-2 col-sm-4 col-6 pt-1 pb-2">
                        Aktiv:  <h6 class="m-0">iviggo ({{(isset($totals['website_status']['active'])) ? $totals['website_status']['active'] : '0'}})</h6>
                        {{--<h6 class="m-0">Partnere ({{(isset($totals['marketing_status']['active'])) ? $totals['marketing_status']['active'] : '0'}})</h6>--}}
                    </div>
                    <div class="col-md-3 col-lg-2 col-sm-4 col-6 pt-1 pb-2">
                        Inaktiv:  <h6 class="m-0">iviggo ({{(isset($totals['website_status']['inactive'])) ? $totals['website_status']['inactive'] : '0'}})</h6>
                        {{--<h6 class="m-0">Partnere ({{(isset($totals['marketing_status']['inactive'])) ? $totals['marketing_status']['inactive'] : '0'}})</h6>--}}
                    </div>
                    <div class="col-md-12 ">
                        <div class="container p-0 mb-5">
                            <div class="row">

                                <div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                    <div class="stat-inner rounded pt-4">
                                        <p class="m-0">Konti i alt</p>
                                        <h2 class="m-0">{{$totals['users']}}</h2>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                    <div class="stat-inner rounded pt-4">
                                        <p class="m-0">Medlemmer</p>
                                        <h2 class="m-0">{{$totals['members']}}</h2>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                    <div class="stat-inner rounded pt-4">
                                        <p class="m-0">Træner</p>
                                        <h2 class="m-0">{{$totals['coaches']}}</h2>
                                    </div>
                                </div>
                                {{--				<div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                                        <div class="stat-inner rounded pt-4">
                                                    <p class="m-0">Area Managers</p>
                                                    <h2 class="m-0">{{$totals['area_managers']}}</h2>
                                                    </div>
                                                </div>--}}
                                {{--		<div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                                <div class="stat-inner rounded pt-4">
                                            <p class="m-0">VIP</p>
                                            <h2 class="m-0">{{$totals['vips']}}</h2>
                                            </div>
                                        </div>--}}
                                {{--<div class="col-lg-2 col-md-4 col-sm-4 col-6 pb-2 statistics text-center">
                                        <div class="stat-inner rounded pt-4">
                                    <p class="m-0">Partners</p>
                                    <h2 class="m-0">{{$totals['partners']-$totals['area_managers'] - $totals['vips']}}</h2>
                                    </div>
                                </div>--}}

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php /*?><div class="table table-responsive   mb-3 overview ">
                <table class="table table-bordered ">
                    <thead>
                    <tr>

                        <th scope="col">Total Accounts</th>
                        <th scope="col">Members</th>
                        <th scope="col">Coach</th>
                        <th scope="col">Area Managers</th>
                        <th scope="col">VIP</th>
                        <th scope="col">Partners</th>
                        <th scope="col">Active</th>
                        <th scope="col">Inactive</th>


                    </tr>
                    </thead>
                    <tbody>

                    <tr>

                        <td>{{$totals['users']}}</td>
                        <td>{{$totals['members']}}</td>
                        <td>{{$totals['coaches']}}</td>
                        <td>{{$totals['area_managers']}}</td>
                        <td>{{$totals['vips']}}</td>
                        <td>{{$totals['partners']-$totals['area_managers'] - $totals['vips']}}</td>
                        <td>
                            <div>
                                <small>Iviggo ({{(isset($totals['website_status']['active'])) ? $totals['website_status']['active'] : '0'}})</small>
                            </div>
                            <small>Partners ({{(isset($totals['marketing_status']['active'])) ? $totals['marketing_status']['active'] : '0'}})</small>
                        </td>
                        <td>
                            <div><small>Iviggo ({{(isset($totals['website_status']['inactive'])) ? $totals['website_status']['inactive'] : '0'}})</small></div>
                            <small>Partners ({{(isset($totals['marketing_status']['inactive'])) ? $totals['marketing_status']['inactive'] : '0'}})</small></td>


                    </tr>
                    </tbody>
                </table>
            </div><?php */?>



            <div class="table-responsive mb-3 overview">
                <table class="table table-striped table-bordered dt-responsive nowrap" style="width:100%" id="members-table">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>Grundlæggende Info</th>
                        <th>Land</th>{{--
                        <th>Refferal Invite code</th>--}}
                        <th>Type</th>
                        {{-- <th>Partners</th>--}}
                        <th>Status</th>
                        <th>Handlinger</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($users as $user)
                        @php
                            $canUpgrade = false;
                        @endphp
                        <tr>
                            <td>{{$loop->iteration}}</td>
                            <td>{{$user->first_name.' '.$user->last_name}}<div class="emailId">{{$user->email}}</div><small>{{isset($user->coachInfo->mobile) ? $user->coachInfo->mobile:''}}</small><br /><small>{{isset($user->coachInfo->invite_code)?$user->coachInfo->invite_code:'' }}</small></td>
                            <td>{{isset($user->coachInfo->country)?$countries[$user->coachInfo->country]:''}}</td>
                            {{--        <td>{{$user->coachInfo->referral_invite_code}}</td>--}}

                            <td class="userRole">
                                @if($user->hasRole('coach'))
                                    Coach
                                @else
                                    Member
                                    @php
                                        $canUpgrade = true;
                                    @endphp
                                @endif
                            </td>
                            {{-- <td class="action-it">
                                 @if($user->marketing_terms=='yes' && $user->hasRole('is_am'))
                                     Area manager<div class="statusId">Accepted</div>
                                 @elseif($user->marketing_terms=='yes' && $user->hasRole('is_vip'))
                                     Coach<div class="statusId">Accepted</div>
                                 @elseif($user->marketing_terms=='yes')
                                     Partner<div class="statusId">Accepted</div>
                                 @else
                                     Not Accepted
                                 @endif
                                 <a href="#" data-id="{{$user->id}}" data-type="m" class="stUp">
                                     @if($user->marketing_terms=='yes')
                                         {{ucwords($user->marketing_status)}}
                                     @endif
                                 </a>
                             </td>--}}
                            <td class="action-it"><a href="#" data-id="{{$user->id}}" data-type="w" class="stUp ">{{($user->status=='active') ? 'Aktiver' : 'Deaktiver'}}</a></td>
                            <td>

                                <button data-toggle="tooltip" data-placement="right" title="Delete this User"  type="button" class="btn-manage  memAction" data-id="{{$user->id}}" data-type="delete"><i class="fa fa-trash" title="delete this user"></i></button>
                                {{--    @if($canUpgrade)
                                        <button data-toggle="tooltip" data-placement="right" title="Upgrade to coach"  type="button" class="btn-manage memAction statusactive" data-id="{{$user->id}}" data-type="upgrade"><i class="fa fa-arrow-up" title="Upgrade to coach"> </i></button>
                                    @endif--}}

                            </td>

                        </tr>
                    @endforeach



                    </tbody>
                </table>


            </div>


        </div>


    </div>


@endsection

