function validate_form(element, rules) {

    $(element).validate({
        rules: rules,
        highlight: function (element) {

            if ($(element).hasClass("input-file")) {
                $(element).parents('.frame').addClass('has-error');
            } else if ($(element).parent().hasClass("filethumb")) {
                $(element).closest('.upload_pictures').addClass('has-error');
            } else if ($(element).parent().hasClass("form-check-label")) {
                $(element).closest('.form-row').addClass('has-error');

            } else {
                $(element).closest('.form-group').addClass('has-error');
            }
        },
        unhighlight: function (element) {

            if ($(element).hasClass("input-file")) {
                $(element).parents('.frame').removeClass('has-error');
            } else if ($(element).parent().hasClass("filethumb")) {
                $(element).closest('.upload_pictures').removeClass('has-error');
            } else if ($(element).parent().hasClass("form-check-label")) {
                $(element).closest('.form-row').removeClass('has-error');

            } else {
                $(element).closest('.form-group').removeClass('has-error');
            }

        },
        errorElement: 'p',
        errorClass: 'help-block',
        errorPlacement: function (error, element) {

            if (element.parents().hasClass('upload_pictures')) {

                $('.upload_pictures').after(error);
            } else if (element.hasClass("chosen-select")) {

                element.siblings('.chosen-container').after(error);
            } else if (element.hasClass("input-file")) {

                element.parents('.center').after(error);
            } else if (element.parent().hasClass("form-check-label")) {

                element.parents(".form-check-label").after(error);

            }  else {

                element.after(error);
            }

        },
        submitHandler: function (form) {

            if (element == '#q_add_form') {

                if ($('#page_pg').val() == 'yes') {
                    form.submit();
                } else {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: site_config.base_url + "/question/add",
                        type: "post",
                        data: $('#q_add_form').serialize(),
                        beforeSend: function () {
                            $.LoadingOverlay("show");
                        },
                        success: function (data) {
                            $('#modalaskQuestion').modal('hide');
                            $.LoadingOverlay("hide");
                            $("#q_add_form").trigger("reset");
                            Swal.fire(
                                'Success!',
                                data.message,
                                'success'
                            );

                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                'There is some error while processing your request.',
                                'error'
                            )
                        }
                    });


                }

            } else if (element == '#coaches-intro-add' || element == '#upload-video') {

                startUpload()

            } else {

                form.submit();
            }


        }
    });
}

// validator methods config
$.validator.addMethod("alpha_space", function (value, element, regexpr) {
    return regexpr.test(value);
}, "Alphabets and spaces are allowed only");

/*$.validator.addMethod('dimention', function(value, element, param) {
    if(element.files.length == 0){
        return true;
    }
    var width = $(element).data('imageWidth');
    var height = $(element).data('imageHeight');
    if(width == param[0] && height == param[1]){
        return true;
    }else{
        return false;
    }
},'Please upload an image with 1170 x 300 pixels dimension');*/


$.validator.addMethod('selectlength', function (value, element, param) {
    var length = $.isArray(value) ? value.length : this.getLength($.trim(value), element);

    if (element.nodeName.toLowerCase() === 'select' && this.settings.rules[$(element).attr('name')].required !== false) {
        // could be an array for select-multiple or a string, both are fine this way
        return length >= param;
    }
    return this.optional(element) || length >= param;
}, 'Please select at least {0} option.');

$.validator.addMethod("alpha-spaces", function (value) {
    var pattern = new RegExp(/^[a-zA-Z\s]+$/);
    return pattern.test(value);
}, "Alphabets and spaces are allowed only");


$.validator.addMethod("dimention", function (value, element, param) {
    var width = $(element).data('imageWidth');
    var height = $(element).data('imageHeight');
    if (this.optional(element) || (width >= param[0] && height >= param[1])) {
        return true;
    } else {
        return false;
    }
}, 'Upload venligst et billede med 500 x 350 pixels dimension');


$.validator.addMethod("emailValidator", function (value, element) {
    return this.optional( element ) || /^.+@[^\.].*\.[a-z]{2,}$/.test( value );

},"Indtast venligst en gyldig e-mailadresse.");


$.validator.addMethod("urlcheck", function (value, element) {
    return this.optional(element) || /^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[^\.].*\.[a-z]{2,}?(\/.*)?$/.test(value);
}, "Indtast venligst den korrekte url-formular.");

$.validator.addMethod("phonecheck", function (value, element) {
    return this.optional(element) || /\(?([0-9]{3})\)?([ .-]?)([0-9]{3})\2([0-9]{4})/.test(value);
}, "Indtast venligst korrekt telefonnummer.");

$.validator.addMethod("nowhitespace", function (value, element) {
    var inputVal = value.trim();

    return this.optional(element) || inputVal;
}, "No white space please");


$.validator.addMethod("equalToPw", function (value, element, param) {
    var target = $(param);
    if (this.settings.onfocusout && target.not(".validate-equalTo-blur").length) {
        target.addClass("validate-equalTo-blur").on("blur.validate-equalTo", function () {
            $(element).valid();
        });
    }
    return value === target.val();
}, ".");


$.validator.addMethod("passwordcheck", function (value, element) {
    return this.optional(element) || /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/.test(value);
}, "Adgangskoder skal være over 8 tegn, Indeholder 1 stort, 1 tal og 1 specialtegn");

$.validator.addMethod("alpha_numeric", function (value, element, regexpr) {
    return regexpr.test(value);
}, "Ugyldige tegn er ikke tilladt");

$.validator.addMethod("secure_password", function (value, element, regexpr) {
    return regexpr.test(value);
}, "Adgangskoder skal være på mindst 8 tegn, Adgangskode skal indeholde mindst 1 stort bogstav, 1 tal og 1 specialtegn.");

$.validator.addMethod("check-year", function (value, element) {
    return (new Date()).getFullYear() >= parseInt(value, 10);
}, "Year in future is not allowed");

$.validator.addMethod("alpha-space", function (value, element, regexpr) {
    var pattern = new RegExp(/^[a-zA-Z\s]*$/);
    return pattern.test(value);
}, "Alphabets and spaces are allowed only");

$.validator.addMethod("alpha-numeric", function (value, element, regexpr) {
    var pattern = new RegExp(/^[a-zA-Z0-9\s\?\,\:\.]*$/);
    return pattern.test(value);
}, "Invalid characters are not allowed");

$.validator.addMethod("inviteregex", function (value, element) {
    return this.optional(element) || /^[a-z0-9]+$/i.test(value);
}, "Invitation Code only contains letters, numbers, or dashes.");

jQuery.validator.addMethod("noSpace", function (value, element) {
    return value.indexOf(" ") < 0 && value != "";
}, "No Empty Space Allowed.");

$.validator.prototype.checkForm = function () {

    this.prepareForm();

    for (var i = 0, elements = (this.currentElements = this.elements()); elements[i]; i++) {
        if (this.findByName(elements[i].name).length != undefined && this.findByName(elements[i].name).length > 1) {
            for (var cnt = 0; cnt < this.findByName(elements[i].name).length; cnt++) {
                this.check(this.findByName(elements[i].name)[cnt]);
            }
        } else {
            this.check(elements[i]);
        }
    }
    return this.valid();
};


$(document).ready(function () {
    var _URL = window.URL || window.webkitURL;
    $('#thumbnail').change(function () {
        $('#thumbnail').removeData('imageWidth');
        $('#thumbnail').removeData('imageHeight');
        var file = this.files[0];
        var tmpImg = new Image();
        tmpImg.src = _URL.createObjectURL(file);
        tmpImg.onload = function () {
            width = tmpImg.naturalWidth,
                height = tmpImg.naturalHeight;
            $('#thumbnail').data('imageWidth', width);
            $('#thumbnail').data('imageHeight', height);
        }
    });


    if (!window.matchMedia || (window.matchMedia("(min-width: 768px)").matches)) {
        // enable tooltips
        $('[data-toggle="tooltip"]').tooltip({
            trigger: 'hover'
        });
    }


    $('.lg_in').on('click', function (e) {
        e.preventDefault();
        Swal.fire({
            showCloseButton: true,
            title: 'Kan ikke afspille denne video!',
            html: '<p>Du skal være medlem for at se video</p>' +
                '<a class="color-two btn-custom" href="' + site_config.base_url + '/login">Log ind</a>&nbsp;&nbsp;&nbsp;' +
                '<a class="color-two btn-custom" href="' + site_config.base_url + '/signup">Tilmeld</a><br />',
        });
    });

    $('.calVat').on('change', function (e) {
        elem = $(this);
        id = $('input[name="package"]').val();
        ccode = elem.val();
        if (id != '' && ccode != '') {
            $.ajax({
                url: site_config.base_url + "/vat/get/" + ccode + "/" + id,
                type: "get",
                beforeSend: function () {
                    // setting a timeout
                    $.LoadingOverlay("show");
                },
                success: function (data) {
                    $.LoadingOverlay("hide");
                    $('input[name="vat_amount"]').val(data.percent_totals);
                    $('#subTotals').html(data.html);

                }
            });
        }
    });

    $('#memberModal, #partnerModal').on('hide.bs.modal', function () {
        var $iframe = jQuery('iframe', jQuery(this)),
            src = $iframe.prop('src');
        $iframe.prop('src', '').prop('src', src.replace('&autoplay=1', ''));
    });


    $('#recSwitch').on('change', function () {


        elem = $(this);
        var id = $(this).data('id');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: site_config.base_url + "/member/recurring",
            type: "post",
            data: {'id': id},
            beforeSend: function () {
                $.LoadingOverlay("show");
            },
            success: function (data) {
                $.LoadingOverlay("hide");

                if (elem.is(':checked')) {
                    elem.next('label').text('Cancel Auto Renew');
                    $(document).find('.expiring').removeClass('expiring');
                } else {
                    $(document).find("[data-expiring='Yes']").addClass('expiring')
                    elem.next('label').text('Auto Renew');
                }


            }, error: function (data) {

                if (elem.is(':checked')) {

                    elem.prop("checked", false);
                }

                $.LoadingOverlay("hide");

            }
        });

    });

    /*$('#termsmkt').on('change',function(e){
        e.preventDefault();
        var pnumber = $("#phone").val();
        var validatedNumber = false;
        if(Math.floor(pnumber) == pnumber && $.isNumeric(pnumber)) {
            $("#phone").parent('div').removeClass('has-lerror');
            validatedNumber = true;
        } else {
            $("#phone").parent('div').addClass('has-lerror');
            validatedNumber = false;
            return false;
        }


        if($(this).prop("checked") == true && validatedNumber){
            $('#mkt-login-form').attr('action',site_config.base_url + "/dologin");

        } else {
            $('#mkt-login-form').attr('action',site_config.base_url + "/login");
        }
    });*/

    let exampleModalCenter = false;

    $('#mkt-login-form').on('keyup keypress', function (e) {
        var keyCode = e.keyCode || e.which;
        if (keyCode === 13 && exampleModalCenter == true) {
            e.preventDefault();
            return false;
        }
    });


    /*$('#mkt-submit-2').on('click', function(e) {

        var number = parseFloat($("#phone").val());
        if (isNaN(number)) {
            $(this).closest('.mobilem').addClass('has-error');
            return false;
        }else{
            $(this).closest('.mobilem').removeClass('has-error');
            return true;
        }

    });*/


    $('#mkt-submit-1').on('click', function (e) {
        e.preventDefault();

        var url = $('#mkt-login-form').attr('action');

        $('#email').val($('#email_1').val());
        $('#password').val($('#password_1').val());

        exampleModalCenter = false;

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: url,
            type: "post",
            data: {'email': $('#email_1').val(), 'password': $('#password_1').val()},
            beforeSend: function () {
                $.LoadingOverlay("show");
            },
            success: function (data) {
                $.LoadingOverlay("hide");

                if (data.continue == true && data.popup == false) {
                    window.location = data.redirect;
                } else {
                    $('input[name="phone"]').val(data.phone);
                    $('input[name="mobile"]').val(data.phone);
                    exampleModalCenter = true;
                    //console.log('Here');
                    if (typeof iti !== 'undefined' && data.phone) {
                        iti.setNumber(data.phone);
                        //console.log('Updated');

                    }
                    $("#exampleModalCenter").modal('show');

                }

            }, error: function (data) {
                $.LoadingOverlay("hide");
                Swal.fire(
                    'Ooops!',
                    data.responseText,
                    'error'
                );

            }
        });

    });


    $(document).on('click', '.askQuestion', function (e) {
        e.preventDefault();
        $('#q_add_form').trigger("reset");
        $('#modalaskQuestion').modal('show');
    });
    $(document).on('click', '.favorite', function (e) {
        e.preventDefault();
        elem = $(this);
        var id = $(this).data('id');
        var type = $(this).data('type');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: site_config.base_url + "/favorite",
            type: "post",
            data: {'id': id, 'type': type},
            beforeSend: function () {
                $.LoadingOverlay("show");
            },
            success: function (data) {
                if (type == 'favorite') {
                    elem.addClass('favorited');
                    Swal.fire(
                        'Success!',
                        'favorite video added. ',
                        'success'
                    )
                }
                if (type == 'unfavorite') {
                    elem.removeClass('favorited');
                    if ($('select[name=type]').val() == 1) {
                        elem.parent('div.col-md-3').remove();
                    }

                }
                elem.html(data.html);
                elem.data('type', data.nextAction);
                $.LoadingOverlay("hide");


            }, error: function (data) {
                $.LoadingOverlay("hide");

            }
        });


    });


    $(document).on('click', '.subscribe', function (e) {
        e.preventDefault();
        elem = $(this);
        var id = $(this).data('id');
        var type = $(this).data('type');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: site_config.base_url + "/subscription",
            type: "post",
            data: {'id': id, 'type': type},
            beforeSend: function () {
                $.LoadingOverlay("show");
            },
            success: function (data) {
                $('.sub_c').children('h4').html(data.count);
                elem.text(data.nextActionTitle);
                elem.data('type', data.nextAction);
                $.LoadingOverlay("hide");


            }, error: function (data) {
                $.LoadingOverlay("hide");

            }
        });


    });


    $('.vimeo_play').on('click', function (e) {
        e.preventDefault();
        $.LoadingOverlay("show");
        var id = $(this).data('id');
        $('.vim_iframe').attr('src', 'https://player.vimeo.com/video/' + id);
        setTimeout(
            function () {
                $('#modalYT').modal('show');
                $.LoadingOverlay("hide");
            }, 1000);
    });

    $('#modalYT').on('hidden.bs.modal', function () {
        // do something…
        $('.vim_iframe').attr('src', '');
    });


    $('.filter').on('change', function (e) {
        // console.log($(this).val());
        //e.preventDefault();
        this.form.submit();

    });

    $('.del_intro').click(function (e) {
        e.preventDefault();
        id = $(this).data('id');
        window.location = site_config.base_url + '/coach/intro/delete/' + id;
    });

    $(".mydropdown").bsMultiSelect({
        cssPatch: {
            choices: {columnCount: '3'},
        }
    });

    $('#passwordold').change(function () {
        if ($(this).val().length > 0) {
            $('#password').prop("disabled", false);
            $('#password1').prop("disabled", false);
        } else {
            $('#password').prop("disabled", true);
            $('#password1').prop("disabled", true);
        }
    });


    validate_form("#mkt-popup-form", {

        'email': {
            required: true,
            emailValidator: true,
        },
        'password': {
            required: true,
        },
        'mobile': {
            digits: true
        },
    });


    validate_form("#coaches-form", {

        'user[email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='user[email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "Den mail er taget" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'general[referral_invite_code]': {
            required: true,
            inviteregex: true
          /*  alpha_numeric: /^[a-zA-Z0-9]+$/*/
        },
        'user[password]': {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'user[password_confirmation]': {
            required: true,
            equalToPw: "#password"
        },
        'user[first_name]': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'user[last_name]': {
            required: true,
            minlength: 2,
            maxlength: 80,
        },
        'general[invite_code]': {
            required: true,
          /*  alpha_numeric: /^[a-zA-Z0-9]+$/*/
            inviteregex: true
        },
        'general[country]': {
            required: true,
        },
        'photo': {
            accept: "image/png,image/jpeg"
        },
        'general[phone]': {
            number: true,
        },
        'general[introduction]': {
            required: true
        },
        'general[expertise]': {
            required: true
        },
        'general[website]': {
            required: true,
            urlcheck: true
        },
        'terms': {
            required: true
        },
        'general[mobile]': {
            digits: true
        },
        'privacy': {
            required: true
        },
    });

    validate_form("#company-form", {

        'company[email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='company[email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "Den mail er taget" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'company[company_email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='company[company_email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "Den mail er taget" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'company[company_name]': {
            required: true
        },
        'company[company_website]': {
            required: true,
            urlcheck: true
        },
        'company[no_of_employees]': {
            required: true
        },
        'company[address]': {
            required: true
        },
        'company[cvr]': {
            required: true
        },
        'company[country]': {
            required: true
        },
        'company[first_name]': {
            required: true
        },
        'company[last_name]': {
            required: true
        },
        'company[start_date]': {
            required: true
        },
        'company[end_date]': {
            required: true
        },
        'company[no_of_members]': {
            required: true
        },
        'company[monthly]': {
            required: true
        }
    });
    validate_form("#company-edit-form", {

     /*   'company[email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='company[email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "That emaThat emailil is taken" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'company[company_email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='company[company_email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "That email is taken" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },*/
        'company[company_name]': {
            required: true
        },
        'company[company_website]': {
            required: true
        },
        'company[no_of_employees]': {
            required: true
        },
        'company[address]': {
            required: true
        },
        'company[cvr]': {
            required: true
        },
        'company[country]': {
            required: true
        },
        'company[first_name]': {
            required: true
        },
        'company[last_name]': {
            required: true
        },
        'company[start_date]': {
            required: true
        },
        'company[end_date]': {
            required: true
        },
        'company[no_of_members]': {
            required: true
        }
    });

    validate_form("#q_add_form", {

        'question[title]': {
            required: true,
            nowhitespace: true,
            maxlength: 200
        },
        'question[description]': {
            required: true,
            nowhitespace: true
        },
        'question[category_id]': {
            required: true,
        }
    });

    validate_form("#users-form", {

        'user[email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='user[email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "Den mail er taget" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'general[referral_invite_code]': {
           /* required: true,*/
            inviteregex: true
        },
        'user[password]': {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'user[password_confirmation]': {
            required: true,
            equalTo: '#password',
        },
        'user[first_name]': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'general[country]': {
            required: true,
        },
        'user[last_name]': {
            required: true,
            minlength: 2,
            maxlength: 80,
        },
        'general[invite_code]': {
            required: true,
            inviteregex: true
        },
        'general[mobile]': {
            digits: true
        },
        'terms': {
            required: true
        },
        'privacy': {
            required: true
        },
    });

    validate_form("#giftuser-form", {
        'giftuser[email]': {
            required: true,
            emailValidator: true
        },
        'giftuser[first_name]': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'giftuser[last_name]': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'giftuser[unique_code]': {
            required: true,
            inviteregex: true
        },
        'giftuser[invitation_code]': {
            required: true,
            inviteregex: true
        },
        'giftuser[password]': {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'giftuser[password_confirmation]': {
            required: true,
            equalTo: '#password',
        },
        'terms': {
            required: true
        },
        'privacy': {
            required: true
        },
    });

    validate_form("#company-employee-form", {

        'employee[email]': {
            required: true,
            emailValidator: true,
            remote: {
                url: site_config.base_url + "/validation/checkusername",
                type: "get",
                data: {
                    email: $("input[name='employee[email]']").val()
                },
                dataFilter: function (data) {
                    var json = JSON.parse(data);
                    if (json.msg == "true") {
                        return "\"" + "Den mail er taget" + "\"";
                    } else {
                        return 'true';
                    }
                }
            }

        },
        'employee[unique_code]': {
            required: true,
            /*inviteregex: true*/
        },
        'employee[password]': {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'employee[password_confirmation]': {
            required: true,
            equalTo: '#password',
        },
        'employee[first_name]': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'employee[last_name]': {
            required: true,
            minlength: 2,
            maxlength: 80,
        },
        'terms': {
            required: true
        },
        'privacy': {
            required: true
        },
    });

    validate_form("#coaches-form-update", {
        'user_old_password': {
            required: function () {
                return $('#password').val().length > 0 || $('#password1').val().length > 0;
            },
            noSpace: function () {
                return $('#password').val().length > 0 || $('#password1').val().length > 0;
            }
        },
        'user_new_password': {
            required: function (element) {
                if ($("#passwordold").val().length > 0) {
                    $('#password').prop("disabled", false);
                    return true;
                } else {
                    $('#password').prop("disabled", true);
                    return false;
                }
            },
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'user_new_password_confirmation': {
            required: function (element) {
                if ($("#passwordold").val().length > 0) {
                    $('#password1').prop("disabled", false);
                    return true;
                } else {
                    $('#password1').prop("disabled", true);
                    return false;
                }
            },
            equalTo: "#password"
        },
        'user_first_name': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'user_last_name': {
            required: true,
            minlength: 2,
            maxlength: 80,
        },
        'general[invite_code]': {
            required: true,
            alpha_numeric: /^[a-zA-Z0-9]+$/
        },
        'general_introduction': {
            required: true
        },
        'general_expertise': {
            required: true
        },
        'mobile': {
            required: true,
            digits: true
        },
        'website': {
            required: true,
            urlcheck: true
        },

    });

    validate_form("#users-form-update", {
        'user_old_password': {
            required: function () {
                return $('#password').val().length > 0 || $('#password1').val().length > 0;
            },
            noSpace: function () {
                return $('#password').val().length > 0 || $('#password1').val().length > 0;
            }
        },
        'user_new_password': {
            required: function (element) {
                if ($("#passwordold").val().length > 0) {
                    $('#password').prop("disabled", false);
                    return true;
                } else {
                    $('#password').prop("disabled", true);
                    return false;
                }
            },
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30
        },
        'user_new_password_confirmation': {
            required: function (element) {
                if ($("#passwordold").val().length > 0) {
                    $('#password1').prop("disabled", false);
                    return true;
                } else {
                    $('#password1').prop("disabled", true);
                    return false;
                }
            },

            equalTo: "#password"
        },
        'user_first_name': {
            required: true,
            minlength: 2,
            maxlength: 40,
        },
        'user_last_name': {
            required: true,
            minlength: 2,
            maxlength: 80,
        },
        'mobile': {
            required: true,
            digits: true
        }

    });

    validate_form("#login-form", {
        email: {
            required: true,
            emailValidator: true
        },
        password: {
            required: true
        }
    });


    validate_form("#forgot-password-form", {
        email: {
            required: true,
            emailValidator: true
        }
    });

    validate_form("#coaches-intro-add", {
        video_title: {
            required: true
        },
        uploadedVideo: {
            required: true,
            accept: "video/*",
            maxFileSize: {
                "unit": "MB",
                "size": 512
            }
        },
        thumbnail: {
            accept: "image/png,image/jpeg,image/jpeg",
            maxFileSize: {
                "unit": "MB",
                "size": 2
            },
            dimention: [500, 350]
        }
    });

    validate_form("#coaches-intro-edit", {
        video_title: {
            required: true
        },
        thumbnail: {
            accept: "image/png,image/jpeg,image/jpeg",
            maxFileSize: {
                "unit": "MB",
                "size": 2
            },
            dimention: [500, 350]
        }
    });

    validate_form("#upload-video", {
        video_title: {
            required: true,
            maxlength: 125

        },
        video_language: {
            required: true
        },
        'video_category[]': {
            required: true,
            selectlength: 1
        },
        uploadedVideo: {
            required: true,
            accept: "video/*",
            maxFileSize: {
                "unit": "MB",
                "size": 512
            }
        },
        thumbnail: {
            accept: "image/png,image/jpeg,image/jpeg",
            maxFileSize: {
                "unit": "MB",
                "size": 2
            },
            dimention: [500, 350]
        }
    });

    validate_form("#upload-video-edit", {
        video_title: {
            required: true,
            maxlength: 125
        },
        video_language: {
            required: true
        },
        'video_category[]': {
            required: true,
            selectlength: 1
        },
        thumbnail: {
            accept: "image/png,image/jpeg,image/jpeg",
            maxFileSize: {
                "unit": "MB",
                "size": 2
            },
            dimention: [500, 350]
        }
    });

    validate_form("#reset-password-form", {
        email: {
            required: true,
            emailValidator: true
        },
        password: {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30,
        },
        password_confirmation: {
            required: true,
            secure_password: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*(_|[^\w])).+$/,
            minlength: 8,
            maxlength: 30,
            equalTo: "#password"
        }
    });
    $("#logout").one("click", function () {
        $(this).click(function () {
            return false;
        });
        $(document).find("#logout-form").submit();
    });

});


