function validate_ajax(element, rules) {

    $(element).validate({
        rules: rules,
        highlight: function(element) {


            if ($(element).hasClass("input-file")) {
                $(element).parents('.frame').addClass('has-error');
            } else if ($(element).parent().hasClass("filethumb")) {
                $(element).closest('.upload_pictures').addClass('has-error');
            } else if ($(element).parent().hasClass("form-check-label")) {
                $(element).closest('.form-row').addClass('has-error');

            } else {
                $(element).closest('.form-group').addClass('has-error');
            }
        },
        unhighlight: function(element) {

            if ($(element).hasClass("input-file")) {
                $(element).parents('.frame').removeClass('has-error');
            } else if ($(element).parent().hasClass("filethumb")) {
                $(element).closest('.upload_pictures').removeClass('has-error');
            } else if ($(element).parent().hasClass("form-check-label")) {
                $(element).closest('.form-row').removeClass('has-error');

            } else {
                $(element).closest('.form-group').removeClass('has-error');
            }

        },
        errorElement: 'p',
        errorClass: 'help-block',
        errorPlacement: function(error, element) {

            if ($(element).hasClass("input-file")) {
                $(element).parents('.center').after(error);
            } else if ($(element).parent().hasClass("filethumb")) {
                $(element).closest('.filethumb').after(error);
            } else if (element.parent().hasClass("form-check-label")) {
                element.parents(".form-check-label").after(error);

            } else {

                element.after(error);
            }

        },
        submitHandler: function(form) {

            if(element=='#add_cat') {

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    beforeSend: function () {
                        // setting a timeout
                        $.LoadingOverlay("show");
                    },

                    url: site_config.base_url + "/bo/categories/submit",
                    type: "post",
                    data: {'category': $('#category').val(), 'type': 'add'},
                    success: function (data) {
                        $.LoadingOverlay("hide");
                        $('form :input').val('');
                        $('.categoriesList').html(data.html);
                        Swal.fire(
                            'Success!',
                             data.message,
                            'success'
                        );

                    }, error: function (data) {
                        $.LoadingOverlay("hide");
                        console.log(data);
                        Swal.fire(
                            'Ooops!',
                            data.responseJSON.message,
                            'error'
                        )
                    }
                });

            }



        }
    });
}

$(document).ready(function () {

    $.validator.setDefaults({ ignore: ":hidden:not(.chosen-select)" })

    $('.tagsinput').tagsinput({
        maxTags: 5,
        maxChars: 15
    });

    $('.chosen-select').chosen({max_selected_options: 6});
    var selector = $('.chosen-select');
    var last_valid_selection = null;
    selector.change(function(event) {
        if ($(this).val().length > 6) {
            $(this).val(last_valid_selection);
        } else {
            last_valid_selection = $(this).val();
        }
    });

    $(".twitter-typeahead").css('display', 'inline');


    $('.edit_intro').on('click',function(e){
        e.preventDefault();
        id = $(this).data('id');
        window.location = site_config.base_url+'/coach/intro/edit/'+id;
    });

    $('.edit_vid').on('click',function(e){
        e.preventDefault();
        id = $(this).data('id');
        window.location = site_config.base_url+'/coach/video/edit/'+id;
    });

    var MembersTable = $('#members-table').DataTable({
        responsive: true,
        language: {
            paginate: {
                next: '&#8594;', // or '→'
                previous: '&#8592;' // or '←'
            }
        },
        fixedColumns: true,
        'columnDefs': [ {
            'targets': [5], // column index (start from 0)
            'orderable': false, // set orderable false for selected columns
        }]
    });

    $(document).on('click','.stUp',function(e) {

        elem = $(this);
        id = elem.data('id');
        type = elem.data('type');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            beforeSend: function () {
                // setting a timeout
                $.LoadingOverlay("show");
            },
            url: site_config.base_url+'/bo/member/status' ,
            type: "post",
            data: {'id': id, 'type': type},
            success: function (data) {
                console.log(data.message);
                elem.html(data.message);
                console.log(elem.html());
                MembersTable.draw('full-hold');

                $.LoadingOverlay("hide");

            }, error: function (data) {
                $.LoadingOverlay("hide");
            }
        });

    });

    $(document).on('click','.memAction',function(e) {
        e.preventDefault();
        elem = $(this);
        id = elem.data('id');
        action = elem.data('type');

            Swal.fire({
                title: 'Are you sure?',
                text: (action=='delete') ? "you want to delete this account!" : "you want to upgrade this user to coach!",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: (action=='delete') ? 'Yes, delete it!' : "Yes, upgrade it!",
            }).then(function(result) {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url+'/bo/member/update' ,
                        type: "post",
                        data: {'id': id, 'type': action},
                        success: function (data) {
                            if(action=='delete') {
                                elem.closest('tr').remove();
                            } else {
                                elem.closest('td').siblings('.userRole').text('Coach');
                                elem.remove();
                            }
                            MembersTable.draw('full-hold');
                            /*MembersTable.destroy();
                            MembersTable = $('#members-table').DataTable({
                                responsive: true,
                                fixedColumns: true,
                                'columnDefs': [ {
                                    'targets': [7], // column index (start from 0)
                                    'orderable': false, // set orderable false for selected columns
                                }]
                            });*/
                            $.LoadingOverlay("hide");

                            if(action!='delete') {
                                Swal.fire(
                                    (action=='delete') ? 'Deleted!' : "Upgraded!" ,
                                    data.message,
                                    'success'
                                )
                            }

                            if(action=='delete') {
                                window.location = site_config.base_url+'/bo/members'
                            }


                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                }


            });

    });



    $(document).on('click','.rcat',function(e) {
        e.preventDefault();
        id = $(this).data('id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            beforeSend: function () {
                // setting a timeout
                $.LoadingOverlay("show");
            },

            url: site_config.base_url + "/bo/categories/submit",
            type: "post",
            data: {'id': id, 'type': 'delete'},
            success: function (data) {
                $.LoadingOverlay("hide");
                $('form :input').val('');
                $('.categoriesList').html(data.html);
                Swal.fire(
                    'Success!',
                    data.message,
                    'success'
                );

            }, error: function (data) {
                $.LoadingOverlay("hide");
                Swal.fire(
                    'Ooops!',
                    data.responseJSON.message,
                    'error'
                )
            }
        });
    });

    $(document).on('click','.rcat_u',function(e) {
        e.preventDefault();
        id = $(this).data('id');
        title = $(this).parent('td').prev('td').children('input[name=DynamicTextBox]').val();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            beforeSend: function () {
                // setting a timeout
                $.LoadingOverlay("show");
            },

            url: site_config.base_url + "/bo/categories/submit",
            type: "post",
            data: {'id': id, 'type': 'update', 'category':title},
            success: function (data) {
                $.LoadingOverlay("hide");
                $('form :input').val('');
                $('.categoriesList').html(data.html);
                Swal.fire(
                    'Success!',
                    data.message,
                    'success'
                );

            }, error: function (data) {
                $.LoadingOverlay("hide");
                Swal.fire(
                    'Ooops!',
                    data.responseJSON.message,
                    'error'
                )
            }
        });
    });


    $(document).on('click','.qsel',function(e) {
        e.preventDefault();
        var qid = $(this).data('id');
        $('#q_Answer').find('#q_videos').data('id',qid);
        $('.s_q_v').each(function() {
            this.checked = false;
        });
        $('#q_Answer').modal('show');
    });

    validate_ajax("#add_cat", {
        category: {
            required: true,
            alpha_space: /^[a-zA-Z0-9\s\-\_\,\#\/\.]*$/
        }
    });

    $(document).on('click', '#q_videos', function (e) {
        e.preventDefault();

        elem = $(this);
        var selecteditems = [];

        $(".s_q_v:checked").each(function (i, ob) {
            selecteditems.push($(ob).val());
        });
        var questionID = elem.data('id');
        if(selecteditems.length > 0) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                beforeSend: function () {
                    // setting a timeout
                    $.LoadingOverlay("show");
                },

                url: site_config.base_url + "/video/questions/update",
                type: "post",
                data: {'question': questionID, 'videos': selecteditems},
                success: function (data) {
                    $.LoadingOverlay("hide");
                    $('#qitem-'+questionID).removeClass('active');
                    $('#qitem-'+questionID).children('div.row').fadeOut('fast');
                    $('#q_Answer').modal('hide');
                    Swal.fire(
                        'Success!',
                        'Your response for question is successfully submitted. ',
                        'success'
                    )

                }, error: function (data) {
                    $.LoadingOverlay("hide");

                }
            });
        }
    });

    $(document).on('click', '.co_act', function (e) {
        e.preventDefault();
        elem = $(this);
        var id = $(this).data('id');
        var type = $(this).data('type');
        console.log(id,type);

        if (type == 'disable') {


            Swal.fire({
                title: 'Are you sure?',
                text: "you want to reject this account!",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, reject it!'
            }).then(function(result) {
                if (result.value) {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/bo/coaches/account",
                        type: "post",
                        data: {'id': id, 'type': type},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.course-single').remove();



                            Swal.fire(
                                'Rejected!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });


                }
            })

        } else if (type == 'enable' || type == 'active') {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: site_config.base_url + "/bo/coaches/account",
                type: "post",
                data: {'id': id, 'type': type},
                beforeSend: function () {
                    // setting a timeout
                    $.LoadingOverlay("show");
                },
                success: function (data) {
                    $.LoadingOverlay("hide");
                    elem.closest('.iconsets').fadeOut('fast', function () {
                        elem.closest('.iconsets').html(data.html).fadeIn('fast');
                        //elem.children('i').removeClass('fa-times').addClass('fa-check');
                        $('[data-toggle="tooltip"]').tooltip();
                    });
                    //elem.children('i').removeClass('fa-check').addClass('fa-times');
                    Swal.fire(
                        'Enabled!',
                        data.message,
                        'success'
                    )

                }, error: function (data) {
                    $.LoadingOverlay("hide");
                    Swal.fire(
                        'Ooops!',
                        data.responseJSON.message,
                        'error'
                    )
                }
            });
        } else if (type == 'remove') {
            Swal.fire({
                title: 'Are you sure?',
                text: "you want to delete this account!",
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then(function(result) {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/bo/coaches/account",
                        type: "post",
                        data: {'id': id, 'type': type},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.course-single').remove();
                            Swal.fire(
                                'Deleted!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                }


            });
        }



    });

    $(document).on('click', '.int_act', function (e) {
        e.preventDefault();
        elem = $(this);
        var id = $(this).data('id');
        var type = $(this).data('type');
        //console.log(id,type);

        if (type == 'approved') {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: site_config.base_url + "/bo/intros/action",
                type: "post",
                data: {'id': id, 'type': type},
                beforeSend: function () {
                    // setting a timeout
                    $.LoadingOverlay("show");
                },
                success: function (data) {
                    $.LoadingOverlay("hide");
                    elem.fadeOut('fast');
                    elem.siblings('button[data-type="reject"]').hide();
                    elem.siblings('button[data-type="remove"]').fadeIn('fast');
                    if ($('select[name=status]').val() == '2') {
                        elem.closest('div.col-md-3').remove();
                    }
                    $('#int-'+id).removeClass('statusv-pending').addClass('statusv-approved').text('Approved');
                    //elem.children('i').removeClass('fa-check').addClass('fa-times');
                    Swal.fire(
                        'Approved!',
                        data.message,
                        'success'
                    )

                }, error: function (data) {

                    if(data.status=='404') {
                        elem.parents('.col-lg-3').remove();
                    }
                    $.LoadingOverlay("hide");
                    Swal.fire(
                        'Ooops!',
                        data.responseJSON.message,
                        'error'
                    )
                }
            });
        } else if (type == 'remove') {
            Swal.fire({
                title: 'Are you sure?',
                text: "you want to delete this video!",
                icon: 'info',
                input: 'textarea',
                inputPlaceholder: 'Add the reason for deletion',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                inputValidator: function(value) {
                    if (!value) {
                        return 'This field is mandatory.'
                    }
                },
            }).then(function(result) {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/bo/intros/action",
                        type: "post",
                        data: {'id': id, 'type': type, 'message': result.value},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.col-lg-3').remove();
                            Swal.fire(
                                'Deleted!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            if(data.status=='404') {
                                elem.parents('.col-lg-3').remove();
                            }
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                } else if(result.value=='') {
                    $.LoadingOverlay("hide");
                    Swal.fire(
                        'Ooops!',
                        data.responseJSON.message,
                        'error'
                    )
                }
            });
        }else if (type == 'reject') {
            Swal.fire({
                title: 'Are you sure?',
                text: "you want to reject/disapprove this video!",
                icon: 'info',
                input: 'textarea',
                inputPlaceholder: 'Add the reason for rejection',
                showCancelButton: true,
                confirmButtonText: 'Yes, reject it!',
                inputValidator: function(value) {
                    if (!value) {
                        return 'This field is mandatory.'
                    }
                },
            }).then(function(result) {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/bo/intros/action",
                        type: "post",
                        data: {'id': id, 'type': type, 'message': result.value},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.col-lg-3').remove();
                            Swal.fire(
                                'Rejected!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            $.LoadingOverlay("hide");
                            if(data.status=='404') {
                                elem.parents('.col-lg-3').remove();
                            }
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                }
            });
        }


    });




    $(function () {
        $("#btnAdd").bind("click", function () {
            var div = $("<tr />");
            div.html(GetDynamicTextBox(""));
            $("#TextBoxContainer").append(div);
        });
        $("body").on("click", ".remove", function () {
            $(this).closest("tr").remove();
        });
    });

    $(document).on('click', '.vd_act', function (e) {
        e.preventDefault();
        elem = $(this);
        var id = $(this).data('id');
        var type = $(this).data('type');
        //console.log(id,type);

        if (type == 'approved') {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: site_config.base_url + "/videos/action",
                type: "post",
                data: {'id': id, 'type': type},
                beforeSend: function () {
                    // setting a timeout
                    $.LoadingOverlay("show");
                },
                success: function (data) {
                    $.LoadingOverlay("hide");

                    elem.fadeOut('fast', function () {
                        nextButton = elem.next('button');
                        elem.next('button').fadeOut('fast');
                        nextButton.next('button').fadeIn('fast');

                        if ($('select[name=status]').val() == '2') {
                            elem.closest('div.col-lg-3').remove();
                        }
                        $('#st-'+id).removeClass('statusv-pending').addClass('statusv-approved').text('Approved');
                        //elem.children('i').removeClass('fa-times').addClass('fa-check');
                    });

                    //elem.children('i').removeClass('fa-check').addClass('fa-times');
                    Swal.fire(
                        'Approved!',
                        data.message,
                        'success'
                    )

                }, error: function (data) {
                    if(data.status=='404') {
                        elem.parents('.col-lg-3').remove();
                    }
                    $.LoadingOverlay("hide");
                    Swal.fire(
                        'Ooops!',
                        data.responseJSON.message,
                        'error'
                    )
                }
            });
        } else if (type == 'remove') {

            Swal.fire({
                title: 'Are you sure?',
                text: "you want to delete this video!",
                icon: 'info',
                showCancelButton: true,
                input: 'textarea',
                inputPlaceholder: 'Why you want to delete this video?',
                confirmButtonText: 'Yes, delete it!',
                showCloseButton:true,
            }).then(function(result) {
                if (result.isDismissed==true) {
                    $.LoadingOverlay("hide");
                }else if (result.isConfirmed==true) {

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/videos/action",
                        type: "post",
                        data: {'id': id, 'type': type,'message': result.value},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.col-lg-3').remove();
                            Swal.fire(
                                'Deleted!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            if(data.status=='404') {
                                elem.parents('.col-lg-3').remove();
                            }
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                }
            });


        } else if (type == 'reject') {
            Swal.fire({
                title: 'Are you sure?',
                text: "you want to reject/disapprove this video!",
                icon: 'info',
                input: 'textarea',
                inputPlaceholder: 'Add the reason for rejection',
                showCancelButton: true,
                confirmButtonText: 'Yes, reject it!',
                inputValidator: function(value) {
                    if (!value) {
                        return 'This field is mandatory.'
                    }
                },
            }).then(function(result) {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        beforeSend: function () {
                            // setting a timeout
                            $.LoadingOverlay("show");
                        },

                        url: site_config.base_url + "/videos/action",
                        type: "post",
                        data: {'id': id, 'type': type, 'message': result.value},
                        success: function (data) {
                            $.LoadingOverlay("hide");
                            elem.parents('.col-lg-3').remove();
                            Swal.fire(
                                'Rejected!',
                                data.message,
                                'success'
                            )

                        }, error: function (data) {
                            if(data.status=='404') {
                                elem.parents('.col-lg-3').remove();
                            }
                            $.LoadingOverlay("hide");
                            Swal.fire(
                                'Ooops!',
                                data.responseJSON.message,
                                'error'
                            )
                        }
                    });
                }
            });
        }

    });


});
