<?php

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');

        // create permissions
        Role::create(['name' => 'is_am']);
        Role::create(['name' => 'is_vip']);
        Role::create(['name' => 'is_mp']);

        // create roles and assign existing permissions
        $superAdmin = Role::create(['name' => 'superadmin']);

        $coach = Role::create(['name' => 'coach']);

        $user = Role::create(['name' => 'user']);
        $manager = Role::create(['name' => 'manager']);





    }
}
