<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSpeakersPoolTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('speakers_pool', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('users_package_id')->unsigned();
            $table->string('amount');
            $table->date('pool_date');
            $table->foreign('users_package_id')->references('id')->on('users_package')->onDelete('cascade')->onUpdate('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('speakers_pool');
    }
}
