<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuickpayRecurringTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {
        Schema::create('quickpay_recurring', function (Blueprint $table) {


            $table->bigIncrements('id');
            $table->integer('recurring_id');
            $table->string('order_id')->nullable();
            $table->string('accepted')->nullable();
            $table->string('type')->nullable();
            $table->string('currency')->nullable();
            $table->string('state')->nullable();
            $table->json('metadata')->nullable();
            $table->json('operations')->nullable();
            $table->bigInteger('subscription_id');
            $table->integer('created_user_id')->unsigned();
            $table->timestamps();

            $table->softDeletes();
            $table->foreign('created_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('quickpay_recurring');
    }
}
