<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVideosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('videos', function (Blueprint $table) {
            $table->increments('id');
            $table->string('video_title');
            $table->string('video_id');
            $table->string('video_thumbnail')->nullable()->default('video_landing.jpg');
            $table->enum('vimeo_callback',array('pending','done'))->default('pending');
            $table->string('video_duration')->nullable();
            $table->string('language');
            $table->enum('visibility',array('public','private'))->default('public');
            $table->enum('status',array('approved','pending'))->default('pending');
            $table->text('video_description')->nullable();
            $table->integer('created_user_id')->unsigned();
            $table->integer('updated_user_id')->unsigned();
            $table->foreign('created_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('updated_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('videos');
    }
}
