<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoachProfileInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coach_profile', function (Blueprint $table) {
            $table->increments('id');
            $table->string('referral_invite_code')->nullable();
            $table->string('country');
            $table->string('invite_code')->unique()->nullable();
            $table->string('photo')->default('default.jpg');
            $table->string('slogan')->nullable();
            $table->text('introduction')->nullable();
            $table->text('expertise')->nullable();
            $table->string('website')->nullable();
            $table->string('company')->nullable();
            $table->string('mobile')->nullable();
            $table->integer('created_user_id')->unsigned();
            $table->integer('updated_user_id')->unsigned();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('created_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('updated_user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('coach_profile');
    }
}
