<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->enum('status',array('active','inactive','disable'));
            $table->string('timezone')->nullable()->default('Europe/Copenhagen');
            $table->string('new_password_token')->nullable();
            $table->string('new_password_attempts')->nullable();
            $table->string('verification_code')->nullable();
            $table->enum('marketing_terms',array('yes','no'))->default('no');
            $table->enum('marketing_status',array('active','inactive'))->default('inactive');
            $table->string('marketing_terms_version')->default('1.0')->nullable();
            $table->dateTime('marketing_inactive')->nullable();
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
