<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Auth;


class VideoView extends Model
{
    protected $table = 'video_views';
    use SoftDeletes;



    protected $fillable = [
        'video_id', 'user_id', 'ip', 'agent'
    ];

    public static function createViewLog($video) {
        $user = Auth::user();
        if($video->created_user_id != $user->id) {
            $postViews= new VideoView();
            $postViews->user_id = $user->id;
            $postViews->video_id = $video->id;
            $postViews->ip = \Request::getClientIp();
            $postViews->agent = \Request::header('User-Agent');
            $postViews->save();//please note to save it at lease, very important
        }

    }

}


