<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Video extends Model
{
    protected $table = 'videos';
    use SoftDeletes;

    protected $appends = ['is_favorite'];

    public function getIsFavoriteAttribute()
    {
        // if you're okay using any pre-loaded relationship
        // will load the relationship if it doesn't exist
        return $this->favorites->count() > 0;
    }



    protected $fillable = [
        'video_id', 'video_title', 'video_duration', 'video_thumbnail', 'video_description', 'language', 'status', 'visibility', 'created_user_id', 'updated_user_id', 'vimeo_callback'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }



    public function Categories()
    {
        return $this->belongsToMany(Category::class, 'video_categories');
    }

    public function favorites()
    {
        return $this->hasMany('App\Favorite',  'video_id');

    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function Tags()
    {
        return $this->belongsToMany(Tag::class, 'video_tags');
    }

}


