<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class UserPackage extends Model
{
    protected $table = 'users_package';

    protected $fillable = [
        'package_id', 'subscription_id','state' ,'recurring', 'status','starts_at', 'ends_at', 'validity_date', 'cancels_at', 'canceled_at','created_user_id' ,'updated_user_id'
    ];

    public function getStartsAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }


    public function getEndsAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }


    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function plan()
    {
        return $this->belongsTo('App\Package','package_id');
    }

    public function quickpaySubscription() {
        return $this->hasMany('App\QuickpaySubscriptions','created_user_id','created_user_id');
    }


}


