<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    protected $table = 'tags';

    protected $fillable = [
        'title', 'slug', 'created_user_id', 'updated_user_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function Videos()
    {
        return $this->belongsToMany(Video::class, 'video_tags');
    }
}


