<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class SitePages extends Model
{
    protected $table = 'site_pages';

    protected $fillable = [
        'title', 'slug', 'content', 'status', 'revision', 'visibility','created_user_id', 'updated_user_id','site_pages'
    ];


    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

}


