<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class QuickpayRecurring extends Model
{
    protected $table = 'quickpay_recurring';

    protected $fillable = [
        'recurring_id', 'order_id', 'accepted', 'created_user_id', 'type', 'currency', 'state', 'metadata', 'operations', 'subscription_id'
    ];



    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

}


