<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class QuickpayPayments extends Model
{
    protected $table = 'quickpay_payments';


    protected $fillable = [
        'payment_id', 'order_id', 'accepted', 'created_user_id', 'type', 'currency', 'state', 'metadata', 'operations', 'subscription_id', 'balance', 'amount','user_package','vat'
    ];



    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function commissions()
    {
        return $this->hasMany('App\Commissions','user_package_id','user_package');
    }

    public function pool()
    {
        return $this->hasMany('App\SpeakersPool','users_package_id','user_package');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


